/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.IOUtils;
import com.atlassian.utils.process.LineReadable;
import com.atlassian.utils.process.ProcessException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;

public abstract class LineOutputHandler
extends BaseOutputHandler {
    private final String encoding;

    protected LineOutputHandler() {
        this(null);
    }

    protected LineOutputHandler(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void process(InputStream output) throws ProcessException {
        LineReadable reader = this.createReader(output, this.encoding);
        this.process(reader);
    }

    protected LineReadable createReader(InputStream stream, String encoding) throws ProcessException {
        InputStreamReader reader;
        if (encoding == null) {
            reader = new InputStreamReader(stream);
        } else {
            try {
                reader = new InputStreamReader(stream, encoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ProcessException("Requested encoding [" + encoding + "] is not supported", e);
            }
        }
        return new BufferReaderLineReader(new BufferedReader(reader));
    }

    protected void process(LineReadable reader) throws ProcessException {
        int counter = 0;
        try {
            String line;
            while ((line = reader.readLine()) != null && !this.isCanceled()) {
                this.resetWatchdog();
                this.processLine(counter++, line);
            }
            this.processInputEnd(counter);
        }
        catch (InterruptedIOException e) {
            this.processEndByException(counter);
        }
        catch (IOException e) {
            this.processEndByException(counter);
            throw new ProcessException(e);
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    protected void processEndByException(int counter) {
    }

    protected void processInputEnd(int lineCount) throws ProcessException {
    }

    protected abstract void processLine(int var1, String var2);

    protected static class BufferReaderLineReader
    implements LineReadable {
        private final BufferedReader reader;

        BufferReaderLineReader(BufferedReader reader) {
            this.reader = reader;
        }

        public String readLine() throws IOException {
            return this.reader.readLine();
        }

        public void close() throws IOException {
            this.reader.close();
        }
    }
}

