/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessFactory;
import com.atlassian.utils.process.ExternalProcessImpl;
import com.atlassian.utils.process.ExternalProcessSettings;
import com.atlassian.utils.process.ProcessMonitor;

public class DefaultExternalProcessFactory
implements ExternalProcessFactory {
    private boolean shutdown;

    public ExternalProcess create(ExternalProcessSettings settings) {
        if (this.shutdown) {
            throw new IllegalStateException("The DefaultExternalProcessFactory has been shutdown; new external processes cannot be created");
        }
        settings.validate();
        ExternalProcessImpl process = new ExternalProcessImpl(settings.getCommand(), settings.getProcessHandler());
        this.configureProcess(process, settings);
        return process;
    }

    public void shutdown() {
        this.shutdown = true;
        ExternalProcessImpl.shutdown();
    }

    protected void configureProcess(ExternalProcessImpl process, ExternalProcessSettings settings) {
        process.setSuppressSpecialWindowsBehaviour(settings.isSuppressSpecialWindowsBehaviour());
        process.setUseWindowsEncodingWorkaround(settings.isUseWindowsEncodingWorkaround());
        process.setWorkingDir(settings.getWorkingDirectory());
        for (ProcessMonitor monitor : settings.getMonitors()) {
            if (monitor == null) {
                throw new IllegalArgumentException("Null ProcessMonitor in the monitors collection");
            }
            process.addMonitor(monitor);
        }
        if (settings.hasEnvironment()) {
            process.setEnvironment(settings.getEnvironment());
        }
        if (settings.hasExecutionTimeout()) {
            process.setExecutionTimeout(settings.getExecutionTimeout());
        }
        if (settings.hasIdleTimeout()) {
            process.setIdleTimeout(settings.getIdleTimeout());
        }
    }
}

