package com.atlassian.utils.process;

/**
 * A default implementation of the {@link ExternalProcessFactory} which builds and configures instances of
 * {@link ExternalProcessImpl}.
 */
public class DefaultExternalProcessFactory implements ExternalProcessFactory {

    private boolean shutdown;

    public ExternalProcess create(ExternalProcessSettings settings) {
        if (shutdown) {
            throw new IllegalStateException("The DefaultExternalProcessFactory has been shutdown; new external processes cannot be created");
        }
        settings.validate();

        ExternalProcessImpl process =  new ExternalProcessImpl(settings.getCommand(), settings.getProcessHandler());
        configureProcess(process, settings);

        return process;
    }

    /**
     * Shuts down the thread pool managed by {@link ExternalProcessImpl}.
     *
     * @see com.atlassian.utils.process.ExternalProcessImpl#shutdown()
     */
    public void shutdown() {
        shutdown = true;

        ExternalProcessImpl.shutdown();
    }

    protected void configureProcess(ExternalProcessImpl process, ExternalProcessSettings settings) {
        process.setSuppressSpecialWindowsBehaviour(settings.isSuppressSpecialWindowsBehaviour());
        process.setUseWindowsEncodingWorkaround(settings.isUseWindowsEncodingWorkaround());
        process.setWorkingDir(settings.getWorkingDirectory());
        for (ProcessMonitor monitor : settings.getMonitors()) {
            if (monitor == null) {
                throw new IllegalArgumentException("Null ProcessMonitor in the monitors collection");
            }
            process.addMonitor(monitor);
        }
        if (settings.hasEnvironment()) {
            process.setEnvironment(settings.getEnvironment());
        }
        if (settings.hasExecutionTimeout()) {
            process.setExecutionTimeout(settings.getExecutionTimeout());
        }
        if (settings.hasIdleTimeout()) {
            process.setIdleTimeout(settings.getIdleTimeout());
        }
    }
}
