/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.utils.process;

import com.atlassian.utils.process.BaseProcessHandler;
import com.atlassian.utils.process.InputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.ProcessException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class PluggableProcessHandler
extends BaseProcessHandler {
    private static final Logger LOGGER = Logger.getLogger(PluggableProcessHandler.class);
    private boolean canceled;
    private boolean complete;
    private OutputHandler errorHandler;
    private ProcessException exception;
    private int exitCode;
    private InputHandler inputHandler;
    private OutputHandler outputHandler;
    private boolean throwOnNonZeroExit = true;

    public PluggableProcessHandler() {
    }

    public PluggableProcessHandler(OutputHandler outputHandler, OutputHandler errorHandler) {
        this();
        this.outputHandler = outputHandler;
        this.errorHandler = errorHandler;
    }

    public PluggableProcessHandler(InputHandler inputHandler, OutputHandler outputHandler, OutputHandler errorHandler) {
        this(outputHandler, errorHandler);
        this.inputHandler = inputHandler;
    }

    @Override
    public void complete(int code, boolean canceled, ProcessException pe) {
        this.canceled = canceled;
        this.exception = pe;
        this.exitCode = code;
        if (this.outputHandler != null) {
            try {
                this.outputHandler.complete();
            }
            catch (Throwable e) {
                this.setException(e);
            }
        }
        if (this.errorHandler != null) {
            try {
                this.errorHandler.complete();
            }
            catch (Throwable e) {
                this.setException(e);
            }
        }
        if (this.inputHandler != null) {
            try {
                this.inputHandler.complete();
            }
            catch (Throwable e) {
                this.setException(e);
            }
        }
        if (pe == null && this.throwOnNonZeroExit && !canceled && code != 0) {
            this.setException(new ProcessException("Non-zero exit code: " + code, code));
        }
        this.complete = true;
    }

    public String getError() {
        return null;
    }

    public OutputHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public ProcessException getException() {
        return this.exception;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public OutputHandler getOutputHandler() {
        return this.outputHandler;
    }

    @Override
    public boolean hasInput() {
        return this.inputHandler != null;
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    public boolean isThrowOnNonZeroExit() {
        return this.throwOnNonZeroExit;
    }

    @Override
    public void processError(InputStream processError) throws ProcessException {
        if (this.errorHandler == null) {
            throw new IllegalStateException("Process error output received with no handler");
        }
        this.errorHandler.setWatchdog(this.getWatchdog());
        this.errorHandler.process(processError);
    }

    @Override
    public void processOutput(InputStream processOutput) throws ProcessException {
        if (this.outputHandler == null) {
            throw new IllegalStateException("Process output received with no handler");
        }
        this.outputHandler.setWatchdog(this.getWatchdog());
        this.outputHandler.process(processOutput);
    }

    @Override
    public void provideInput(OutputStream processInput) {
        if (!this.hasInput()) {
            throw new IllegalStateException("Attempt to read input without an input handler");
        }
        this.inputHandler.setWatchdog(this.getWatchdog());
        this.inputHandler.process(processInput);
    }

    @Override
    public void reset() {
        this.canceled = false;
        this.complete = false;
        this.exception = null;
        this.exitCode = 0;
    }

    @Override
    public boolean succeeded() {
        return this.exception == null;
    }

    public void setErrorHandler(OutputHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setException(Throwable e) {
        if (this.exception == null) {
            this.exception = e instanceof ProcessException ? (ProcessException)e : new ProcessException(e);
        } else {
            LOGGER.debug((Object)"Ignored exception as exception for handler is already set", e);
        }
    }

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public void setOutputHandler(OutputHandler outputHandler) {
        this.outputHandler = outputHandler;
    }

    public void setThrowOnNonZeroExit(boolean throwOnNonZeroExit) {
        this.throwOnNonZeroExit = throwOnNonZeroExit;
    }
}

