package com.atlassian.utils.process;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.StringWriter;

/**
 * An Output Handler which captures the output stream to a string
 */
public class StringOutputHandler extends BaseOutputHandler {
    private final String encoding;
    private final StringWriter sw = new StringWriter();

    public StringOutputHandler() {
        this(null);
    }

    public StringOutputHandler(String encoding) {
        this.encoding = encoding;
    }

    public void process(InputStream output) throws ProcessException {
        InputStreamReader reader;
        try {
            if (encoding == null) {
                reader = new InputStreamReader(output);
            } else {
                reader = new InputStreamReader(output, encoding);
            }

            char buffer[] = new char[1024];
            int num;
            while ((num = reader.read(buffer)) != -1) {
                resetWatchdog();
                sw.write(buffer, 0, num);
            }
        } catch (InterruptedIOException e) {
            // This means the process was asked to stop which can be normal so we just finish
        } catch (IOException e) {
            throw new ProcessException(e);
        }
    }

    public String getOutput() {
        return sw.toString();
    }

    @Override
    public void complete() {
        IOUtils.closeQuietly(sw);
    }
}
