package com.atlassian.utils.process;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.IOException;

/**
 * An input handler which provides the input from the given string.
 */
public class StringInputHandler implements InputHandler {
    private String encoding;
    private String content;

    public StringInputHandler(String content) {
        this(null, content);
    }

    public StringInputHandler(String encoding, String content) {
        this.encoding = encoding;
        this.content = content;
    }

    public void process(OutputStream input) {
        OutputStreamWriter writer = null;
        try {
            if (encoding == null) {
                writer = new OutputStreamWriter(input);
            } else {
                writer = new OutputStreamWriter(input, encoding);
            }
            writer.write(content);
        } catch (IOException e) {
            throw new RuntimeException(e);
        } finally {
            IOUtils.closeQuietly(writer);
        }
    }

    public void complete() {
        // nothing to do here
    }

    public void setWatchdog(Watchdog watchdog) {
    }
}
