/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache;

import com.atlassian.util.contentcache.CacheExpiryStrategy;
import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.EvictionStrategy;
import com.atlassian.util.contentcache.NoOpEvictionStrategy;
import com.atlassian.util.contentcache.StreamPumper;
import com.atlassian.util.contentcache.TtlCacheExpiryStrategy;
import com.atlassian.util.contentcache.internal.AbstractContentCacheManager;
import com.atlassian.util.contentcache.internal.FileContentCache;
import com.atlassian.util.contentcache.internal.NoOpStreamPumper;
import com.atlassian.util.contentcache.internal.util.MoreFiles;
import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class FileContentCacheManager
extends AbstractContentCacheManager {
    private final Object cacheCreationLock = new Object();
    private final Path cacheDir;
    private final long evictionFreeSpaceBytes;
    private final CacheExpiryStrategy expiryStrategy;
    private final long hysteresis;
    private final long minFreeSpaceBytes;

    private FileContentCacheManager(Builder builder) {
        super(builder.streamPumper, builder.evictionStrategy, builder.expiryCheckIntervalMillis);
        this.cacheDir = MoreFiles.mkdir(builder.cacheDir);
        this.expiryStrategy = builder.expiryStrategy;
        this.minFreeSpaceBytes = builder.minFreeSpaceBytes;
        this.evictionFreeSpaceBytes = builder.evictionFreeSpaceBytes;
        this.hysteresis = builder.hysteresis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    protected ContentCache createContentCache(String regionKey, StreamPumper streamPumper) {
        Object object = this.cacheCreationLock;
        synchronized (object) {
            return new FileContentCache(regionKey, this.expiryStrategy, streamPumper, this, this.cacheDir.resolve(regionKey), this.minFreeSpaceBytes, this.evictionFreeSpaceBytes, this.hysteresis);
        }
    }

    public static class Builder {
        public static final int ONE_GB = 0x40000000;
        private final Path cacheDir;
        private long expiryCheckIntervalMillis;
        private CacheExpiryStrategy expiryStrategy;
        private EvictionStrategy evictionStrategy;
        private long evictionFreeSpaceBytes;
        private long minFreeSpaceBytes;
        private long hysteresis;
        private StreamPumper streamPumper;

        public Builder(@Nonnull File cacheDir) {
            this(((File)Preconditions.checkNotNull((Object)cacheDir, (Object)"cacheDir")).toPath());
        }

        public Builder(@Nonnull Path cacheDir) {
            this.cacheDir = (Path)Preconditions.checkNotNull((Object)cacheDir, (Object)"cacheDir");
            this.expiryCheckIntervalMillis = TimeUnit.SECONDS.toMillis(30L);
            this.expiryStrategy = new TtlCacheExpiryStrategy();
            this.minFreeSpaceBytes = 0x40000000L;
            this.evictionFreeSpaceBytes = this.minFreeSpaceBytes + 0x40000000L;
            this.hysteresis = 0x40000000L;
            this.evictionStrategy = new NoOpEvictionStrategy();
            this.streamPumper = new NoOpStreamPumper();
        }

        @Nonnull
        public FileContentCacheManager build() {
            return new FileContentCacheManager(this);
        }

        @Nonnull
        public Builder expiryCheckInterval(long value, @Nonnull TimeUnit timeUnit) {
            Preconditions.checkArgument((value > 0L ? 1 : 0) != 0, (Object)"checkInterval must be > 0");
            this.expiryCheckIntervalMillis = timeUnit.toMillis(value);
            return this;
        }

        @Nonnull
        public Builder expiryStrategy(@Nonnull CacheExpiryStrategy value) {
            this.expiryStrategy = (CacheExpiryStrategy)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        @Nonnull
        public Builder evictionStrategy(@Nonnull EvictionStrategy value) {
            Preconditions.checkNotNull((Object)value, (Object)"EvictionStrategy");
            this.evictionStrategy = value;
            return this;
        }

        @Nonnull
        public Builder minFreeSpaceBytes(long value) {
            Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (Object)"minimum free space must be >= 0");
            this.minFreeSpaceBytes = value;
            return this;
        }

        @Nonnull
        public Builder evictionFreeSpaceBytes(long value) {
            Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (Object)"eviction free space must be >= 0");
            this.evictionFreeSpaceBytes = value;
            return this;
        }

        @Nonnull
        public Builder hysteresis(long value) {
            Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (Object)"hysteresis must be >= 0");
            this.hysteresis = value;
            return this;
        }

        @Nonnull
        public Builder streamPumper(StreamPumper value) {
            this.streamPumper = (StreamPumper)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }
    }
}

