/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache.internal;

import com.atlassian.util.contentcache.CacheExpiryStrategy;
import com.atlassian.util.contentcache.ContentCacheManager;
import com.atlassian.util.contentcache.StreamPumper;
import com.atlassian.util.contentcache.internal.AbstractCacheEntry;
import com.atlassian.util.contentcache.internal.AbstractContentCache;
import com.atlassian.util.contentcache.internal.FileCacheEntry;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class FileContentCache
extends AbstractContentCache {
    private static final long MIN_SPACE_WARNING_WAIT = TimeUnit.MINUTES.toMillis(5L);
    private final File cacheDirectory;
    private final long minFreeSpaceBytes;
    private final long evictionFreeSpaceBytes;
    private final long hysteresis;
    private final ContentCacheManager contentCacheManager;
    private volatile long lastLoggedSpaceWarningTimestamp;

    public FileContentCache(@Nonnull String key, @Nonnull File cacheDirectory, @Nonnull CacheExpiryStrategy expiryStrategy, @Nonnull StreamPumper streamPump, long minFreeSpaceBytes, long evictionFreeSpaceBytes, long hysteresis, @Nonnull ContentCacheManager contentCacheManager) {
        super(key, expiryStrategy, streamPump);
        Preconditions.checkArgument((evictionFreeSpaceBytes >= 0L ? 1 : 0) != 0, (Object)"evictionFreeSpaceBytes must be >= 0");
        Preconditions.checkArgument((hysteresis >= 0L ? 1 : 0) != 0, (Object)"hysteresis must be >= 0");
        Preconditions.checkArgument((minFreeSpaceBytes >= 0L ? 1 : 0) != 0, (Object)"minFreeSpaceBytes must be >= 0");
        this.evictionFreeSpaceBytes = evictionFreeSpaceBytes;
        this.contentCacheManager = (ContentCacheManager)Preconditions.checkNotNull((Object)contentCacheManager, (Object)"contentCacheManager");
        this.cacheDirectory = (File)Preconditions.checkNotNull((Object)cacheDirectory);
        this.hysteresis = hysteresis;
        this.minFreeSpaceBytes = minFreeSpaceBytes;
        Preconditions.checkState((cacheDirectory.mkdirs() || cacheDirectory.isDirectory() ? 1 : 0) != 0, (String)"Failed to create cache directory at: {}", (Object[])new Object[]{cacheDirectory.getAbsolutePath()});
    }

    @Override
    protected AbstractCacheEntry newCacheEntry(@Nonnull String cacheKey, @Nonnull Date expiry) throws IOException {
        FileCacheEntry.processCleanupQueue();
        long freeSpace = this.cacheDirectory.getFreeSpace();
        if (freeSpace < this.evictionFreeSpaceBytes) {
            this.contentCacheManager.evict(this.hysteresis + this.evictionFreeSpaceBytes - freeSpace);
            freeSpace = this.cacheDirectory.getFreeSpace();
        }
        if (freeSpace < this.minFreeSpaceBytes) {
            if (this.lastLoggedSpaceWarningTimestamp < System.currentTimeMillis() - MIN_SPACE_WARNING_WAIT) {
                log.warn("content-cache@{}: caching has been temporarily disabled because there is not enough space left on {}", (Object)this.getStatistics().getKey(), (Object)this.cacheDirectory.getAbsolutePath());
                this.lastLoggedSpaceWarningTimestamp = System.currentTimeMillis();
            }
            return null;
        }
        return new FileCacheEntry(cacheKey, this.key, this.cacheDirectory, expiry, this.expiryStrategy);
    }
}

