/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache;

import com.atlassian.util.contentcache.CacheExpiryStrategy;
import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.EvictionStrategy;
import com.atlassian.util.contentcache.NoOpEvictionStrategy;
import com.atlassian.util.contentcache.StreamPumper;
import com.atlassian.util.contentcache.TtlCacheExpiryStrategy;
import com.atlassian.util.contentcache.internal.AbstractContentCacheManager;
import com.atlassian.util.contentcache.internal.FileContentCache;
import com.atlassian.util.contentcache.internal.NoOpStreamPumper;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class FileContentCacheManager
extends AbstractContentCacheManager {
    private final Object cacheCreationLock = new Object();
    private final File cacheDirectory;
    private final long evictionFreeSpaceBytes;
    private final CacheExpiryStrategy expiryStrategy;
    private final long hysteresis;
    private final long minFreeSpaceBytes;

    private FileContentCacheManager(Builder builder) {
        super(builder.streamPumper, builder.evictionStrategy, builder.expiryCheckIntervalMillis);
        this.cacheDirectory = builder.cacheDirectory;
        this.expiryStrategy = builder.expiryStrategy;
        this.minFreeSpaceBytes = builder.minFreeSpaceBytes;
        this.evictionFreeSpaceBytes = builder.evictionFreeSpaceBytes;
        this.hysteresis = builder.hysteresis;
        Preconditions.checkState((this.cacheDirectory.isDirectory() || this.cacheDirectory.mkdirs() ? 1 : 0) != 0, (String)"Failed to create directory: {}", (Object[])new Object[]{this.cacheDirectory.getAbsolutePath()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ContentCache createContentCache(String regionKey, StreamPumper streamPumper) {
        Object object = this.cacheCreationLock;
        synchronized (object) {
            return new FileContentCache(regionKey, new File(this.cacheDirectory, regionKey), this.expiryStrategy, streamPumper, this.minFreeSpaceBytes, this.evictionFreeSpaceBytes, this.hysteresis, this);
        }
    }

    public static class Builder {
        public static final int ONE_GB = 0x40000000;
        private final File cacheDirectory;
        private long expiryCheckIntervalMillis;
        private CacheExpiryStrategy expiryStrategy;
        private EvictionStrategy evictionStrategy;
        private long evictionFreeSpaceBytes;
        private long minFreeSpaceBytes;
        private long hysteresis;
        private StreamPumper streamPumper;

        public Builder(File cacheDirectory) {
            this.cacheDirectory = (File)Preconditions.checkNotNull((Object)cacheDirectory, (Object)"cacheDirectory");
            this.expiryCheckIntervalMillis = TimeUnit.SECONDS.toMillis(30L);
            this.expiryStrategy = new TtlCacheExpiryStrategy();
            this.minFreeSpaceBytes = 0x40000000L;
            this.evictionFreeSpaceBytes = this.minFreeSpaceBytes + 0x40000000L;
            this.hysteresis = 0x40000000L;
            this.evictionStrategy = new NoOpEvictionStrategy();
            this.streamPumper = new NoOpStreamPumper();
        }

        public FileContentCacheManager build() {
            return new FileContentCacheManager(this);
        }

        public Builder expiryCheckInterval(long value, @Nonnull TimeUnit timeUnit) {
            Preconditions.checkArgument((value > 0L ? 1 : 0) != 0, (Object)"checkInterval must be > 0");
            this.expiryCheckIntervalMillis = timeUnit.toMillis(value);
            return this;
        }

        public Builder expiryStrategy(@Nonnull CacheExpiryStrategy value) {
            this.expiryStrategy = (CacheExpiryStrategy)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }

        public Builder evictionStrategy(@Nonnull EvictionStrategy value) {
            Preconditions.checkNotNull((Object)value, (Object)"EvictionStrategy");
            this.evictionStrategy = value;
            return this;
        }

        public Builder minFreeSpaceBytes(long value) {
            Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (Object)"minimum free space must be >= 0");
            this.minFreeSpaceBytes = value;
            return this;
        }

        public Builder evictionFreeSpaceBytes(long value) {
            Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (Object)"eviction free space must be >= 0");
            this.evictionFreeSpaceBytes = value;
            return this;
        }

        public Builder hysteresis(long value) {
            Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (Object)"hysteresis must be >= 0");
            this.hysteresis = value;
            return this;
        }

        public Builder streamPumper(StreamPumper value) {
            this.streamPumper = (StreamPumper)Preconditions.checkNotNull((Object)value, (Object)"value");
            return this;
        }
    }
}

