/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache;

import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.StreamPumper;
import com.atlassian.util.contentcache.internal.AbstractContentCacheManager;
import com.atlassian.util.contentcache.internal.FileContentCache;
import com.atlassian.util.contentcache.internal.NoOpStreamPumper;
import com.google.common.base.Preconditions;
import java.io.File;
import javax.annotation.Nonnull;

public class FileContentCacheManager
extends AbstractContentCacheManager {
    private final Object cacheCreationLock = new Object();
    private final File cacheDirectory;
    private final long minFreeSpaceBytes;

    public FileContentCacheManager(@Nonnull File cacheDirectory, long minFreeSpaceBytes, long expiryCheckIntervalMillis) {
        this(new NoOpStreamPumper(), cacheDirectory, minFreeSpaceBytes, expiryCheckIntervalMillis);
    }

    public FileContentCacheManager(@Nonnull StreamPumper pumper, @Nonnull File cacheDirectory, long minFreeSpaceBytes, long expiryCheckIntervalMillis) {
        super(pumper, expiryCheckIntervalMillis);
        this.cacheDirectory = (File)Preconditions.checkNotNull((Object)cacheDirectory, (Object)"cacheDirectory");
        this.minFreeSpaceBytes = minFreeSpaceBytes;
        Preconditions.checkState((cacheDirectory.isDirectory() || cacheDirectory.mkdirs() ? 1 : 0) != 0, (String)"Failed to create directory: {}", (Object[])new Object[]{cacheDirectory.getAbsolutePath()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ContentCache createContentCache(String regionKey, StreamPumper streamPumper) {
        Object object = this.cacheCreationLock;
        synchronized (object) {
            return new FileContentCache(streamPumper, regionKey, new File(this.cacheDirectory, regionKey), this.minFreeSpaceBytes);
        }
    }
}

