/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache;

import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.ContentCacheManager;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

public abstract class AbstractContentCacheManager
implements ContentCacheManager {
    private final ConcurrentMap<String, ContentCache> caches;
    private final Executor executor;

    public AbstractContentCacheManager(@Nonnull ConcurrentMap<String, ContentCache> caches, Executor executor) {
        this.executor = executor;
        this.caches = (ConcurrentMap)Preconditions.checkNotNull(caches);
    }

    @Override
    @Nonnull
    public ContentCache getCache(@Nonnull String regionKey) {
        Preconditions.checkNotNull((Object)regionKey);
        ContentCache cache = (ContentCache)this.caches.get(regionKey);
        while (cache == null) {
            ContentCache newCache = this.createContentCache(regionKey, this.executor);
            cache = this.caches.putIfAbsent(regionKey, newCache);
            if (cache != null) continue;
            cache = newCache;
            this.didAddCache(cache);
        }
        return cache;
    }

    protected abstract ContentCache createContentCache(String var1, Executor var2);

    @Override
    public void clear() {
        Iterator it = this.caches.values().iterator();
        while (it.hasNext()) {
            ContentCache cache = (ContentCache)it.next();
            it.remove();
            cache.clear();
            this.didRemoveCache(cache);
        }
    }

    @Override
    public void remove(@Nonnull String regionKey) {
        ContentCache cache = (ContentCache)this.caches.remove(regionKey);
        if (cache != null) {
            cache.clear();
            this.didRemoveCache(cache);
        }
    }

    protected void didAddCache(ContentCache cache) {
    }

    protected void didRemoveCache(ContentCache cache) {
    }
}

