/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.contentcache;

import com.atlassian.util.contentcache.ContentCache;
import com.atlassian.util.contentcache.ContentProvider;
import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContentCache
implements ContentCache {
    protected static final Logger LOG = LoggerFactory.getLogger(ContentCache.class);
    private final ConcurrentMap<String, CacheEntry> cache;
    private final Executor executor;

    protected AbstractContentCache(ConcurrentMap<String, CacheEntry> cache) {
        this(cache, (Executor)MoreExecutors.sameThreadExecutor());
    }

    protected AbstractContentCache(ConcurrentMap<String, CacheEntry> cache, Executor executor) {
        this.cache = cache;
        this.executor = executor;
    }

    @Override
    public InputStream getStream(@Nonnull String cacheKey) throws IOException {
        InputStream input;
        Preconditions.checkNotNull((Object)cacheKey);
        CacheEntry entry = (CacheEntry)this.cache.get(cacheKey);
        InputStream inputStream = input = entry != null ? entry.getInput() : null;
        if (input != null) {
            LOG.debug("Hit cache for for key {}.", (Object)cacheKey);
        } else {
            LOG.debug("Missed cache for for key {}.", (Object)cacheKey);
        }
        return input;
    }

    @Override
    @Nonnull
    public InputStream getStream(@Nonnull String cacheKey, @Nonnull ContentProvider provider) throws IOException {
        Preconditions.checkNotNull((Object)cacheKey);
        Preconditions.checkNotNull((Object)provider);
        CacheEntry entry = (CacheEntry)this.cache.get(cacheKey);
        InputStream input = entry != null ? entry.getInput() : null;
        int misses = 0;
        while (input == null) {
            ++misses;
            LOG.debug("Missed cache for key {}.", (Object)cacheKey);
            CacheEntry newEntry = this.newCacheEntry(cacheKey);
            entry = this.cache.putIfAbsent(cacheKey, newEntry);
            if (entry == null) {
                entry = newEntry;
                this.writeToCache(entry, provider);
                this.didAddEntry(entry);
                LOG.debug("New entry stored for key {}.", (Object)cacheKey);
            } else {
                LOG.debug("entry found after miss for key {}. Closing newly created entry.", (Object)cacheKey);
                Closeables.closeQuietly((Closeable)newEntry);
            }
            input = entry.getInput();
        }
        if (misses == 0) {
            LOG.debug("Hit cache for for key {}.", (Object)cacheKey);
        } else {
            LOG.debug("Missed cache for for key {}. Miss count: {}.", (Object)cacheKey, (Object)misses);
        }
        return input;
    }

    protected void writeToCache(final CacheEntry entry, final ContentProvider cacheWriter) {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OutputStream out = null;
                try {
                    out = entry.getOutput();
                    cacheWriter.apply(out);
                }
                catch (IOException e) {
                    LOG.warn(String.format("Failed to write to cache entry with key %s", entry.getKey()), (Throwable)e);
                    Closeables.closeQuietly((Closeable)entry);
                }
                finally {
                    Closeables.closeQuietly((Closeable)out);
                }
            }
        });
    }

    @Nonnull
    protected abstract CacheEntry newCacheEntry(String var1) throws IOException;

    @Override
    public void clear() {
        Iterator it = this.cache.values().iterator();
        while (it.hasNext()) {
            CacheEntry entry = (CacheEntry)it.next();
            it.remove();
            Closeables.closeQuietly((Closeable)entry);
            this.didRemoveEntry(entry);
        }
    }

    @Override
    public void remove(@Nonnull String cacheKey) {
        CacheEntry entry = (CacheEntry)this.cache.remove(cacheKey);
        if (entry != null) {
            Closeables.closeQuietly((Closeable)entry);
            this.didRemoveEntry(entry);
        }
    }

    protected void didAddEntry(CacheEntry entry) {
    }

    protected void didRemoveEntry(CacheEntry entry) {
    }

    protected static abstract class CacheEntry
    implements InputSupplier<InputStream>,
    OutputSupplier<OutputStream>,
    Closeable {
        private final String cacheKey;

        protected CacheEntry(String cacheKey) {
            this.cacheKey = cacheKey;
        }

        public String getKey() {
            return this.cacheKey;
        }

        @Nullable
        public abstract InputStream getInput() throws IOException;

        @Nonnull
        public abstract OutputStream getOutput() throws IOException;

        @Override
        public void close() throws IOException {
        }
    }
}

