/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.Deferred;
import com.atlassian.util.concurrent.Effect;
import com.atlassian.util.concurrent.Effects;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.RuntimeInterruptedException;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public final class Promises {
    private Promises() {
    }

    public static <V> Promise<List<V>> when(Promise<? extends V> ... promises) {
        return Promises.when(Arrays.asList(promises));
    }

    public static <V> Promise<List<V>> when(Iterable<? extends Promise<? extends V>> promises) {
        return Promises.forListenableFuture(Futures.allAsList(promises));
    }

    public static <V> Promise<V> promise(V value) {
        return new Of(Futures.immediateFuture(value));
    }

    public static <V> Promise<V> rejected(Throwable throwable, Class<V> resultType) {
        return new Of(Futures.immediateFailedFuture((Throwable)throwable));
    }

    public static <V> Promise<V> toResolvedPromise(V value) {
        return Deferred.create().resolve(value).promise();
    }

    public static <V> Promise<V> toRejectedPromise(Throwable t, Class<V> resultType) {
        return Deferred.create().reject(t).promise();
    }

    public static <V> Promise<V> forListenableFuture(ListenableFuture<V> future) {
        return new Of<V>(future);
    }

    public static Effect<Throwable> reject(final Deferred<?> delegate) {
        return new Effect<Throwable>(){

            @Override
            public void apply(Throwable t) {
                delegate.reject(t);
            }
        };
    }

    public static Effect<Throwable> reject(final SettableFuture<?> delegate) {
        return new Effect<Throwable>(){

            @Override
            public void apply(Throwable t) {
                delegate.setException(t);
            }
        };
    }

    public static <V> FutureCallback<V> futureCallback(final Effect<V> success, final Effect<Throwable> failure) {
        return new FutureCallback<V>(){

            public void onSuccess(V result) {
                success.apply(result);
            }

            public void onFailure(Throwable t) {
                failure.apply(t);
            }
        };
    }

    public static <V> FutureCallback<V> onSuccessDo(Effect<V> effect) {
        return Promises.futureCallback(effect, Effects.<Throwable>noop());
    }

    public static <V> FutureCallback<V> onFailureDo(Effect<Throwable> effect) {
        return Promises.futureCallback(Effects.noop(), effect);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Of<V>
    extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V>
    implements Promise<V> {
        public Of(ListenableFuture<V> delegate) {
            super(delegate);
        }

        @Override
        public V claim() {
            try {
                return (V)this.delegate().get();
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new RuntimeException(cause);
            }
        }

        @Override
        public Promise<V> done(Effect<V> e) {
            this.on(Promises.onSuccessDo(e));
            return this;
        }

        @Override
        public Promise<V> fail(Effect<Throwable> e) {
            this.on(Promises.onFailureDo(e));
            return this;
        }

        @Override
        public Promise<V> on(FutureCallback<V> callback) {
            Futures.addCallback((ListenableFuture)this.delegate(), callback);
            return this;
        }

        @Override
        public <O> Promise<O> map(Function<? super V, ? extends O> function) {
            return Promises.forListenableFuture(Futures.transform((ListenableFuture)this, function));
        }

        @Override
        public <T> Promise<T> flatMap(final Function<? super V, Promise<T>> f) {
            final SettableFuture result = SettableFuture.create();
            final Effect<Throwable> failResult = Promises.reject(result);
            this.done(new Effect<V>(){

                @Override
                public void apply(V v) {
                    Promise next = (Promise)f.apply(v);
                    next.done(new Effect<T>(){

                        @Override
                        public void apply(T t) {
                            result.set(t);
                        }
                    }).fail(failResult);
                }
            }).fail(failResult);
            return new Of<V>(result);
        }
    }
}

