/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class WeakIterable<E>
implements Iterable<E> {
    private final Queue<WeakReference<E>> queue = new LinkedBlockingQueue<WeakReference<E>>();

    E add(E e) {
        this.queue.add(new WeakReference<E>(e));
        return e;
    }

    boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator iterator = this.queue.iterator();
        return new Iterator<E>(){
            E next = this.getNext();

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public E next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                try {
                    Object e = this.next;
                    return e;
                }
                finally {
                    this.next = this.getNext();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            E getNext() {
                Object result = null;
                while (result == null) {
                    if (!iterator.hasNext()) {
                        return null;
                    }
                    WeakReference ref = (WeakReference)iterator.next();
                    Object e = ref.get();
                    if (e == null) {
                        iterator.remove();
                        continue;
                    }
                    result = e;
                }
                return result;
            }
        };
    }
}

