/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.AbstractCopyOnWriteMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class CopyOnWriteSortedMap<K, V>
extends AbstractCopyOnWriteMap<K, V, SortedMap<K, V>>
implements SortedMap<K, V> {
    private static final long serialVersionUID = 7375772978175545647L;

    static <K, V> CopyOnWriteSortedMap<K, V> newTreeMap() {
        return new CopyOnWriteSortedMap(Functions.tree());
    }

    static <K, V> CopyOnWriteSortedMap<K, V> newTreeMap(SortedMap<K, V> map) {
        return new CopyOnWriteSortedMap<K, V>(map, Functions.tree());
    }

    static <K, V> CopyOnWriteSortedMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new CopyOnWriteSortedMap(new TreeMap(comparator), Functions.tree());
    }

    public CopyOnWriteSortedMap(SortedMap<K, V> map, CopyFunction<SortedMap<K, V>> factory) {
        super(map, factory);
    }

    public CopyOnWriteSortedMap(CopyFunction<SortedMap<K, V>> factory) {
        super(new TreeMap(), factory);
    }

    @Override
    public Comparator<? super K> comparator() {
        return ((SortedMap)this.getDelegate()).comparator();
    }

    @Override
    public K firstKey() {
        return ((SortedMap)this.getDelegate()).firstKey();
    }

    @Override
    public K lastKey() {
        return ((SortedMap)this.getDelegate()).lastKey();
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return Collections.unmodifiableSortedMap(((SortedMap)this.getDelegate()).headMap(toKey));
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return Collections.unmodifiableSortedMap(((SortedMap)this.getDelegate()).tailMap(fromKey));
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return Collections.unmodifiableSortedMap(((SortedMap)this.getDelegate()).subMap(fromKey, toKey));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Functions {
        public static <K, V> CopyFunction<SortedMap<K, V>> tree() {
            return new CopyFunction<SortedMap<K, V>>(){

                @Override
                public SortedMap<K, V> copy(SortedMap<K, V> map) {
                    return new TreeMap(map);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface CopyFunction<M extends SortedMap<?, ?>>
    extends AbstractCopyOnWriteMap.CopyFunction<M> {
    }
}

