/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.Supplier;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import net.jcip.annotations.ThreadSafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public abstract class LazyReference<T>
extends WeakReference<T>
implements Supplier<T> {
    private final FutureTask<T> future = new FutureTask(new Callable<T>(){

        @Override
        public T call() throws Exception {
            return LazyReference.this.create();
        }
    });

    public LazyReference() {
        super(null);
    }

    protected abstract T create() throws Exception;

    @Override
    public final T get() {
        boolean interrupted = false;
        while (true) {
            try {
                T t = this.getInterruptibly();
                return t;
            }
            catch (InterruptedException ignore) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public final T getInterruptibly() throws InterruptedException {
        if (!this.future.isDone()) {
            this.future.run();
        }
        try {
            return this.future.get();
        }
        catch (ExecutionException e) {
            throw new InitializationException(e);
        }
    }

    public boolean isInitialized() {
        return this.future.isDone();
    }

    public void cancel() {
        this.future.cancel(true);
    }

    public static class InitializationException
    extends RuntimeException {
        private static final long serialVersionUID = 3638376010285456759L;

        InitializationException(ExecutionException e) {
            super(e.getCause() != null ? e.getCause() : e);
        }
    }
}

