package com.atlassian.jira.usercompatibility;

import com.atlassian.crowd.embedded.api.User;

/**
 * Represents user with key
 */
public interface UserWithKey
{

    /**
     * @return the user identified by key
     */
    User getUser();

    /**
     * @return the key which distinguishes the ApplicationUser as unique
     */
    String getKey();

    /**
     * Implementations must ensure equality based on getKey().
     *
     * @param obj object to compare to.
     * @return <code>true</code> if and only if the key matches.
     */
    boolean equals(Object obj);

    /**
     * Implementations must produce a hashcode based on getKey().
     *
     * @return hashcode.
     */
    int hashCode();
}
