package com.atlassian.user.search.page;

import com.atlassian.user.Entity;
import com.opensymphony.util.TextUtils;
import org.apache.log4j.Category;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/***
 * Util class for making it easier to work with paging iterators
 *
 * TODO: Roll these methods into an extension of the Pager interface
 */
public class PagerUtils
{
    public static final Category log = Category.getInstance(PagerUtils.class);
    public static final Pager EMPTY_PAGER = Pager.EMPTY_PAGER;
    public static final String ESCAPEDCOMMA = "ESCAPEDCOMMA";

    public static <T> List<T> toList(Pager<T> pager)
    {
        ArrayList<T> list = new ArrayList<T>();

        for (T obj : pager)
        {
            list.add(obj);
        }

        return list;
    }

    public static int count(Pager pager)
    {
        Iterator iter = pager.iterator();

        int count = 0;

        while (iter.hasNext())
        {
            iter.next();
            count++;
        }

       return count;
    }

    /**
     * @deprecated since 1.25. In general, the Pager should not be used wherever possible. Manually extract entity names
     * from the Pager itself if it is still required. 
     */
    @SuppressWarnings("unchecked") /* not genericised because it's deprecated */
    public static List toListOfEntityNames(Pager pager)
    {
        ArrayList list = new ArrayList();

        for (Object aPager : pager)
        {
            Entity e = (Entity) aPager;
            if (e == null)
            {
                log.error("null entity in pager");
            }
            else
            {
                list.add(e.getName());
            }
        }

        return list;
    }

    /**
     * For example, for cn=jsmith,dc=atlassian,dc=com this returns jsmith.
     * If the distinguishedName is not well formed, this will be logged and it will be returned as is
     * @deprecated This method will only get the first element of the DN which wont necessarily be
     *   username.  To get the username from a DN you should look the record up for the DN
     *   and query the username attribute. 
     */
    public static String extractSearchResultName(String distinguishedName)
    {
        String result = distinguishedName;

        if (!TextUtils.stringSet(distinguishedName))
            return result;

        distinguishedName = distinguishedName.replaceAll("\\\\,", ESCAPEDCOMMA);
        String[] rdns = distinguishedName.split(",");

        boolean invalidDN = true;
        if (rdns.length >= 1)
        {
            String[] firstPhrase = rdns[0].split("=");
            if (firstPhrase.length >= 2)
            {
                result = firstPhrase[1].replaceAll(ESCAPEDCOMMA, "\\\\,");
                invalidDN = false;
            }
        }

        if (log.isDebugEnabled() && invalidDN)
            log.debug("Could not extract name from search result: " + distinguishedName);

        return result;
    }
}
