package com.atlassian.user.security.password;

import static org.apache.commons.codec.binary.Base64.encodeBase64;
import static org.apache.commons.codec.digest.DigestUtils.sha512;

/**
 * Encrypts the password using a SHA-512 digest of the bytes, returned as a base64-encoded String.
 * <p/>
 * Note: the conversion from String to bytes is done using the default platform encoding in order
 * to preserve backwards compatibility with OSUser passwords.
 */
public final class DefaultPasswordEncryptor implements PasswordEncryptor
{
    public String encrypt(String unencryptedPassword)
    {
        byte[] bytes = unencryptedPassword.getBytes(); // for compatibility with OSUser - use platform encoding
        byte[] hash = sha512(bytes);
        return new String(encodeBase64(hash)); // for compatibility with OSUser - use platform encoding
    }

    public String getEncryptedValue(Credential credential)
    {
        if (credential.isEncrypted())
        {
            return credential.getValue();
        }
        else
        {
            return encrypt(credential.getValue());
        }
    }
}
