package com.atlassian.user.search.query.match;

import org.apache.commons.lang.StringUtils;

/**
 * Matches if <code>content.startsWith(searchTerm)</code> returns true after the arguments have been converted to lower
 * case. If either argument is null or the content is an empty string (""), returns false.
 */
public class StartsWithIgnoreCaseMatcher implements Matcher
{
    public boolean matches(String content, String searchTerm)
    {
        if (StringUtils.isBlank(content) || searchTerm == null)
            return false;
        return content.toLowerCase().startsWith(searchTerm.toLowerCase());
    }
}
