package com.atlassian.user.search.query;

import com.atlassian.user.Entity;

import java.util.List;
import java.util.Arrays;

public class MultiTermBooleanQuery<T extends Entity> extends AbstractBooleanQuery<T>
{
    private Query<T>[] collatedQueries;

    public MultiTermBooleanQuery(Query<T>[] collatedQueries, boolean anding)
    {
        super(anding);
        this.collatedQueries = collatedQueries;
    }

    public List<Query<T>> getQueries()
    {
        return Arrays.asList(collatedQueries);
    }

    /**
     * Returns a multi-term boolean query which joins the provided queries using AND.
     *
     * @param queries the components of the boolean query
     * @since 2.1
     */
    public static <T extends Entity> Query<T> allOf(Query<T>... queries)
    {
        return new MultiTermBooleanQuery<T>(queries, true);
    }

    /**
     * Returns a multi-term boolean query which joins the provided queries using OR.
     *
     * @param queries the components of the boolean query
     * @since 2.1
     */
    public static <T extends Entity> Query<T> anyOf(Query<T>... queries)
    {
        return new MultiTermBooleanQuery<T>(queries, false);
    }
}
