package com.atlassian.user.search.query;

import com.atlassian.user.repository.RepositoryIdentifier;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DefaultQueryContext implements QueryContext
{
    private final List<String> repositoryKeys;

    /**
     * Constructs a mutable query context which can be modified via {@link #addRepositoryKey(String)}.
     *
     * @deprecated since 2.1 construct an immutable version using {@link #DefaultQueryContext(RepositoryIdentifier...)} or
     * {@link #DefaultQueryContext(String...)}
     */
    public DefaultQueryContext()
    {
        repositoryKeys = new ArrayList<String>();
    }

    /**
     * Construct an immutable query context for the specified repositories.
     *
     * @param repositories the repositories to query
     */
    public DefaultQueryContext(RepositoryIdentifier... repositories)
    {
        List<String> keys = new ArrayList<String>(repositories.length);
        for (RepositoryIdentifier repository : repositories)
            keys.add(repository.getKey());
        repositoryKeys = Collections.unmodifiableList(keys);
    }

    /**
     * Construct an immutable query context for the specified repository keys.
     *
     * @param repositoryKeys the keys of the repositories to query
     */
    public DefaultQueryContext(String... repositoryKeys)
    {
        this.repositoryKeys = Collections.unmodifiableList(Arrays.asList(repositoryKeys));
    }

    // legacy method which will be removed when the interface methods go
    public void addRepositoryKey(String key) throws IllegalArgumentException
    {
        if (repositoryKeys.contains(key) || repositoryKeys.contains(QueryContext.ALL_REPOSITORIES))
            throw new IllegalArgumentException("Repository key [" + key + " is already listed in this query context.");

        repositoryKeys.add(key);
    }

    // legacy method which will be removed when the interface methods go
    public List<String> getRepositoryKeys()
    {
        return Collections.unmodifiableList(repositoryKeys);
    }

    public boolean contains(RepositoryIdentifier repositoryIdentifier)
    {
        // legacy check which will be removed when the interface methods go
        if (getRepositoryKeys().contains(QueryContext.ALL_REPOSITORIES))
            return true;
        return getRepositoryKeys().contains(repositoryIdentifier.getKey());
    }
}
