package com.atlassian.user.impl.ldap.search;

import net.sf.ldaptemplate.support.filter.Filter;

import javax.naming.NamingEnumeration;
import javax.naming.directory.SearchResult;

/**
 * A util class which holds a {@link javax.naming.NamingEnumeration} and a {@link String}
 * representing the initial ldap search query.
 *
 * We use this because the {@link com.atlassian.user.impl.ldap.search.page.LDAPEntityPager}
 * needs to be able to repeat the original search to preload the next {@link com.atlassian.user.search.page.Pager@PRELOAD_LIMIT}
 * entries, either on a call to {@link com.atlassian.user.search.page.Pager#skipTo(int)} or
 * {@link com.atlassian.user.search.page.Pager#nextPage()}.
 *
 */

public class LDAPPagerInfo
{
    private NamingEnumeration<SearchResult> enume;
    private Filter relatingSearchQuery;
    private String originalBaseSearchContext;
    private boolean searchAllDepths;
    private String[] returningAttributes;
    private final int timeToLive;

    public LDAPPagerInfo(NamingEnumeration<SearchResult> enume, Filter originalSearchQuery,
                            String originalBaseSearchContext, boolean searchAllDepths,
                            String[] returningAttributes, int timeToLive)
    {
        this.enume = enume;
        this.relatingSearchQuery = originalSearchQuery;
        this.originalBaseSearchContext = originalBaseSearchContext;
        this.searchAllDepths = searchAllDepths;
        this.returningAttributes = returningAttributes;
        this.timeToLive = timeToLive;
    }

    public NamingEnumeration<SearchResult> getNamingEnumeration()
    {
        return enume;
    }

    /**
     * @return a query which relates to the search result. The query itself may not be identical to the original
     * search query used to generate the associated naming enumeration but its evaluation will produce results which
     * relate to the enumeration.
     */
    public Filter getLDAPQuery()
    {
        return relatingSearchQuery;
    }

    public String getBaseSearchContext()
    {
        return originalBaseSearchContext;
    }

    public void setLDAPQuery(Filter relatingQuery)
    {
        this.relatingSearchQuery = relatingQuery;
    }

    public boolean isSearchAllDepths()
    {
        return searchAllDepths;
    }

    public String[] getReturningAttributes()
    {
        return returningAttributes;
    }

    public int getTimeToLive()
    {
        return timeToLive;
    }
}
