package com.atlassian.user.impl.ldap;

import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.properties.LdapSearchProperties;
import com.atlassian.user.User;
import com.atlassian.util.profiling.UtilTimerStack;

import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

public class DefaultLDAPUserFactory implements LDAPUserFactory
{
    private final LdapSearchProperties searchProperties;

    public DefaultLDAPUserFactory(LdapSearchProperties searchProperties)
    {
        this.searchProperties = searchProperties;
    }

    public DefaultLDAPUser getUser(Attributes attrs, String distinguishedName) throws RepositoryException
    {
        DefaultLDAPUser user;

        if (distinguishedName.indexOf(searchProperties.getBaseUserNamespace()) == -1)
            distinguishedName = distinguishedName + "," + searchProperties.getBaseUserNamespace();

        try
        {
            Attribute uidAttr = attrs.get(searchProperties.getUsernameAttribute());
            if (uidAttr == null) return null;

            user = new DefaultLDAPUser((String) uidAttr.get(), distinguishedName);

            if (UtilTimerStack.isActive())
            {
                String stackKey = this.getClass().getName() + "_getUser(" + user.getName() + ")";
                UtilTimerStack.push(stackKey);
            }

            Attribute givenNameAttr = attrs.get(searchProperties.getFirstnameAttribute());
            Attribute surNameAttr = attrs.get(searchProperties.getSurnameAttribute());

            if (givenNameAttr != null)
            {
                String givenName = (String) givenNameAttr.get();

                String surName = "";

                if (surNameAttr != null)
                    surName = (String) surNameAttr.get();

                givenName = givenName.concat(" ");
                user.setFullName(givenName.concat(surName));
            }

            Attribute emailAttr = attrs.get(searchProperties.getEmailAttribute());
            if (emailAttr != null)
                user.setEmail((String) emailAttr.get());

        }
        catch (NamingException e)
        {
            throw new RepositoryException(e);
        }

        if (UtilTimerStack.isActive())
        {
            String stackKey = this.getClass().getName() + "_getUser(" + user.getName() + ")";
            UtilTimerStack.pop(stackKey);
        }

        return user;
    }

    public Collection<User> getUsers(Enumeration userNamingEnumeration) throws RepositoryException
    {
        if (UtilTimerStack.isActive())
            UtilTimerStack.push(this.getClass().getName() + "_getUserCollection");

        ArrayList<User> users = new ArrayList<User>();

        while (userNamingEnumeration.hasMoreElements())
        {
            SearchResult result = (SearchResult) userNamingEnumeration.nextElement();
            Attributes attrs = result.getAttributes();
            users.add(getUser(attrs, result.getName()));
        }

        if (UtilTimerStack.isActive())
            UtilTimerStack.pop(this.getClass().getName() + "_getUserCollection");

        return users;
    }

    public DefaultLDAPUser getEntity(Attributes attrs, String distinguishedName) throws RepositoryException
    {
        if (distinguishedName.startsWith("\"") && distinguishedName.endsWith("\""))
        {
            distinguishedName = distinguishedName.substring(1,distinguishedName.length() - 1);
        }
        return getUser(attrs, distinguishedName);
    }
}
