package com.atlassian.user.configuration.util;

import com.opensymphony.util.TextUtils;
import com.atlassian.user.configuration.ConfigurationException;

import java.util.HashMap;
import java.util.Set;

/**
 * A helper class to generalize how each init(..) method reports back if it has not been configured with
 * the correct data.
 * <p/>
 */
public class InitializationCheck
{
    public static void validateArgs(HashMap dependencies, String[] requiredDependencyKeys, Object caller) throws ConfigurationException
    {
        Set keySet = dependencies.keySet();

        String errMessage = "";

        for (int i = 0; i < requiredDependencyKeys.length; i++)
        {
            String key = requiredDependencyKeys[i];

            if (!keySet.contains(key))
            {
                errMessage += "Unsatisfied dependency in [" + caller.getClass().getName() + "] - missing [" + key + "]. ";
            }
        }

        if (TextUtils.stringSet(errMessage))
            throw new ConfigurationException(errMessage);
    }
}
