package com.atlassian.user.configuration;

import com.atlassian.user.GroupManager;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.delegation.DelegatingGroupManager;
import com.atlassian.user.impl.delegation.DelegatingUserManager;
import com.atlassian.user.impl.delegation.properties.DelegatingPropertySetFactory;
import com.atlassian.user.impl.delegation.search.query.DelegatingEntityQueryParser;
import com.atlassian.user.impl.delegation.security.authentication.DelegatingAuthenticator;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.repository.DefaultRepositoryIdentifier;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.security.authentication.Authenticator;

import java.util.*;

public class DefaultDelegationAccessor implements DelegationAccessor
{
    private Map<RepositoryIdentifier, RepositoryAccessor> repositoryAccessors = new HashMap<RepositoryIdentifier, RepositoryAccessor>();
    private List<RepositoryIdentifier> delegationOrder = new ArrayList<RepositoryIdentifier>();

    private DelegatingAuthenticator delegatingAuthenticator;
    private DelegatingGroupManager delegatingGroupManager;
    private DelegatingPropertySetFactory delegatingPropertySetFactory;
    private DelegatingUserManager delegatingUserManager;
    private DelegatingEntityQueryParser delegatingEntityQueryParser;

    private List<Authenticator> authenticators = new ArrayList<Authenticator>();
    private List<UserManager> userManagers = new ArrayList<UserManager>();
    private List<GroupManager> groupManagers = new ArrayList<GroupManager>();
    private List<PropertySetFactory> propertySetFactories = new ArrayList<PropertySetFactory>();
    private List<EntityQueryParser> entityQueryParsers = new ArrayList<EntityQueryParser>();

    public DefaultDelegationAccessor()
    {
    }

    public DefaultDelegationAccessor(List<RepositoryAccessor>/*<RepositoryAccessor>*/ repositoryAccessors)
    {
        for (Iterator<RepositoryAccessor> iterator = repositoryAccessors.iterator(); iterator.hasNext();)
        {
            RepositoryAccessor accessor = iterator.next();
            addRepositoryAccessor(accessor);
        }
    }

    public RepositoryIdentifier getIdentifier()
    {
        return new DefaultRepositoryIdentifier("delegatingRepository", "Delegating Repository");
    }

    public UserManager getUserManager()
    {
        return delegatingUserManager;
    }

    public GroupManager getGroupManager()
    {
        return delegatingGroupManager;
    }

    public PropertySetFactory getPropertySetFactory()
    {
        return delegatingPropertySetFactory;
    }

    public Authenticator getAuthenticator()
    {
        return delegatingAuthenticator;
    }

    public EntityQueryParser getEntityQueryParser()
    {
        return delegatingEntityQueryParser;
    }

    public RepositoryAccessor getRepositoryAccessor(String key)
    {
        for (Iterator<RepositoryIdentifier> it = repositoryAccessors.keySet().iterator(); it.hasNext();)
        {
            RepositoryIdentifier identifier = it.next();
            if (identifier.getKey().equals(key))
                return repositoryAccessors.get(identifier);
        }
        return null;
    }

    public List getRepositoryAccessors()
    {
        List<RepositoryAccessor> result = new LinkedList<RepositoryAccessor>();
        for (Iterator<RepositoryIdentifier> it = delegationOrder.iterator(); it.hasNext();)
        {
            RepositoryIdentifier identifier = it.next();
            result.add(repositoryAccessors.get(identifier));
        }
        return result;
    }

    public void addRepositoryAccessor(RepositoryAccessor accessor)
    {
        repositoryAccessors.put(accessor.getIdentifier(), accessor);
        delegationOrder.add(accessor.getIdentifier());

        if (accessor.getAuthenticator() != null) authenticators.add(accessor.getAuthenticator());
        if (accessor.getUserManager() != null) userManagers.add(accessor.getUserManager());
        if (accessor.getGroupManager() != null) groupManagers.add(accessor.getGroupManager());
        if (accessor.getPropertySetFactory() != null) propertySetFactories.add(accessor.getPropertySetFactory());
        if (accessor.getEntityQueryParser() != null) entityQueryParsers.add(accessor.getEntityQueryParser());

        delegatingUserManager = new DelegatingUserManager(userManagers);
        delegatingAuthenticator = new DelegatingAuthenticator(delegatingUserManager, authenticators);
        delegatingPropertySetFactory = new DelegatingPropertySetFactory(propertySetFactories);
        delegatingGroupManager = new DelegatingGroupManager(groupManagers);
        delegatingEntityQueryParser = new DelegatingEntityQueryParser(entityQueryParsers);
    }
}
