package com.atlassian.user.util;

import com.atlassian.cache.Cache;

import java.util.Collection;

/**
 * Cheat to allow us to treat caches as if they have been genericised. As of now, atlassian-cache hasn't been
 * made generic for backwards compatibility reasons.
 */
@SuppressWarnings({"unchecked"})
public class GenericCacheWrapper<K, V>
{
    private final Cache cache;

    public GenericCacheWrapper(Cache cache)
    {
        this.cache = cache;
    }

    public String getName()
    {
        return cache.getName();
    }

    public Collection<K> getKeys()
    {
        return cache.getKeys();
    }

    public V get(K key)
    {
        return (V) cache.get(key);
    }

    public void put(K key, V value)
    {
        cache.put(key, value);
    }

    public void remove(K key)
    {
        cache.remove(key);
    }

    public void removeAll()
    {
        cache.removeAll();
    }

}
