package com.atlassian.user.search.query.match;

import org.apache.commons.lang.StringUtils;

/**
 * Matches if {@link StringUtils#contains} returns true for the two arguments after they have been
 * converted to lower case. If either argument is null, returns false.
 */
public class ContainsIgnoreCaseMatcher implements Matcher
{
    public boolean matches(String content, String searchTerm)
    {
        if (content == null || searchTerm == null)
            return false;
        return StringUtils.contains(content.toLowerCase(), searchTerm.toLowerCase());
    }
}
