package com.atlassian.user.impl.ldap;

import com.atlassian.user.configuration.DefaultRepositoryAccessor;
import com.atlassian.user.impl.ldap.adaptor.LDAPGroupAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.impl.ldap.repository.LdapContextFactory;
import com.atlassian.user.impl.ldap.properties.LdapSearchProperties;
import com.atlassian.user.impl.ldap.properties.LdapMembershipProperties;
import com.atlassian.user.impl.ldap.properties.LdapConnectionProperties;

/**
 * Includes all the additional objects for accessing an LDAP repository.
 */
public class LdapRepositoryAccessor extends DefaultRepositoryAccessor
{
    private LdapContextFactory contextFactory;
    private LDAPGroupAdaptor groupAdaptor;
    private LDAPUserAdaptor userAdaptor;
    private LDAPGroupFactory groupFactory;
    private LDAPUserFactory userFactory;
    private LdapSearchProperties searchProperties;
    private LdapMembershipProperties membershipProperties;
    private LdapConnectionProperties connectionProperties;

    public LdapContextFactory getContextFactory()
    {
        return contextFactory;
    }

    public void setContextFactory(LdapContextFactory contextFactory)
    {
        this.contextFactory = contextFactory;
    }

    public LDAPGroupAdaptor getGroupAdaptor()
    {
        return groupAdaptor;
    }

    public void setGroupAdaptor(LDAPGroupAdaptor groupAdaptor)
    {
        this.groupAdaptor = groupAdaptor;
    }

    public LDAPUserAdaptor getUserAdaptor()
    {
        return userAdaptor;
    }

    public void setUserAdaptor(LDAPUserAdaptor userAdaptor)
    {
        this.userAdaptor = userAdaptor;
    }

    public LDAPGroupFactory getGroupFactory()
    {
        return groupFactory;
    }

    public void setGroupFactory(LDAPGroupFactory groupFactory)
    {
        this.groupFactory = groupFactory;
    }

    public LDAPUserFactory getUserFactory()
    {
        return userFactory;
    }

    public void setUserFactory(LDAPUserFactory userFactory)
    {
        this.userFactory = userFactory;
    }

    public LdapSearchProperties getSearchProperties()
    {
        return searchProperties;
    }

    public void setSearchProperties(LdapSearchProperties searchProperties)
    {
        this.searchProperties = searchProperties;
    }

    public LdapMembershipProperties getMembershipProperties()
    {
        return membershipProperties;
    }

    public void setMembershipProperties(LdapMembershipProperties membershipProperties)
    {
        this.membershipProperties = membershipProperties;
    }

    public LdapConnectionProperties getConnectionProperties()
    {
        return connectionProperties;
    }

    public void setConnectionProperties(LdapConnectionProperties connectionProperties)
    {
        this.connectionProperties = connectionProperties;
    }
}
