package com.atlassian.user.impl.hibernate;

import net.sf.hibernate.SessionFactory;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.user.ExternalEntity;

public class CachingExternalEntityDAO extends DefaultExternalEntityDAO
{
    private CacheFactory cacheFactory;

    public CachingExternalEntityDAO(SessionFactory sessionFactory, CacheFactory cacheFactory)
    {
        super(sessionFactory);
        this.cacheFactory = cacheFactory;
    }

    public ExternalEntity getExternalEntity(final String externalEntityName)
    {
        Long id = (Long) getCache().get(externalEntityName);
        if (id != null)
            return (ExternalEntity) getHibernateTemplate().get(DefaultHibernateExternalEntity.class, id);

        ExternalEntity externalEntity = super.getExternalEntity(externalEntityName);
        if (externalEntity != null)
            cacheEntity(externalEntityName, externalEntity);

        return externalEntity;
    }

    public void removeExternalEntity(final String externalEntityName)
    {
        getCache().remove(externalEntityName);
        super.removeExternalEntity(externalEntityName);
    }

    public ExternalEntity createExternalEntity(String externalEntityName)
    {
        ExternalEntity entity = super.createExternalEntity(externalEntityName);
        cacheEntity(externalEntityName, entity);
        return entity;
    }

    private Cache getCache()
    {
        return cacheFactory.getCache(this.getClass().getName() + ".externalEntityName");
    }
       
    private void cacheEntity(String externalEntityName, ExternalEntity entity)
    {
        getCache().put(externalEntityName, new Long(entity.getId()));
    }
}
