/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.search.query;

import com.atlassian.user.search.query.BooleanQuery;
import com.atlassian.user.search.query.EntityQueryException;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.GroupQuery;
import com.atlassian.user.search.query.MembershipQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryValidator;
import com.atlassian.user.search.query.TermQuery;
import com.atlassian.user.search.query.UserQuery;

public abstract class AbstractEntityQueryParser
implements EntityQueryParser {
    private final QueryValidator queryValidator = new QueryValidator();

    protected void validateQuery(Query query) throws EntityQueryException {
        this.queryValidator.assertValid(query);
    }

    protected void validateBooleanToQueryType(BooleanQuery query, String queryClassName) throws EntityQueryException {
        this.queryValidator.assertValid(query);
    }

    protected String matchQueryToQueryType(Query query) {
        if (query instanceof UserQuery) {
            return UserQuery.class.getName();
        }
        if (query instanceof GroupQuery) {
            return GroupQuery.class.getName();
        }
        if (query instanceof MembershipQuery) {
            return MembershipQuery.class.getName();
        }
        return null;
    }

    protected Query identifyDefiningQuery(BooleanQuery booleanQuery) {
        if (booleanQuery instanceof MembershipQuery) {
            return booleanQuery;
        }
        for (Query query : booleanQuery.getQueries()) {
            if (query instanceof TermQuery) {
                return query;
            }
            if (!(query instanceof BooleanQuery)) continue;
            return this.identifyDefiningQuery((BooleanQuery)query);
        }
        return null;
    }
}

