package com.atlassian.user.search.query.match;

import org.apache.commons.lang.StringUtils;

/**
 * Matches if <code>content.endsWith(searchTerm)</code> returns true after the arguments have been converted to lower
 * case. If either argument is null or the content is an empty string (""), returns false.
 */
public class EndsWithIgnoreCaseMatcher implements Matcher
{
    public boolean matches(String content, String searchTerm)
    {
        if (StringUtils.isBlank(content) || searchTerm == null)
            return false;
        return content.toLowerCase().endsWith(searchTerm.toLowerCase());
    }
}
