package com.atlassian.user.search.query;

/**
 * Query used to search for users that match a particular username query (say tom*) and group query (say confluence-*)
 *
 * @deprecated since 2.1 because this isn't supported by all LDAP servers or by Crowd
 */
public class UsersInGroupTwoTermQuery extends TwoTermBooleanQuery implements MembershipQuery
{
    public UsersInGroupTwoTermQuery(UserNameTermQuery userNameQuery)
    {
        super(userNameQuery, new GroupNameTermQuery(TermQuery.WILDCARD), true);
    }

    public UsersInGroupTwoTermQuery(GroupNameTermQuery groupNameQuery)
    {
        super(new UserNameTermQuery(TermQuery.WILDCARD), groupNameQuery, true);
    }

    public UsersInGroupTwoTermQuery(UserNameTermQuery userNameQuery, GroupNameTermQuery groupNameQuery)
    {
        super(userNameQuery, groupNameQuery, true);
    }

    public UserNameTermQuery getUserNameTermQuery()
    {
        return (UserNameTermQuery) getFirstQuery();
    }

    public GroupNameTermQuery getGroupNameTermQuery()
    {
        return (GroupNameTermQuery) getSecondQuery();
    }
}
