package com.atlassian.user.search;

import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerFactory;

import java.util.*;

public class DefaultSearchResult<T> implements SearchResult<T>
{
    private Map<String, Pager<T>> repoKeyToResults = new LinkedHashMap<String, Pager<T>>();

    public DefaultSearchResult(){}

    public DefaultSearchResult(Pager<T> result, String repositoryKey)
    {
        addToResults(repositoryKey, result);
    }

    public Pager<T> pager()
    {
        return PagerFactory.getPager(new ArrayList<Pager<T>>(repoKeyToResults.values()));
    }

    public void addToResults(String repositoryKey, Pager<T> pager)
    {
        repoKeyToResults.put(repositoryKey, pager);
    }

    public Pager<T> pager(String repoKey)
    {
        return repoKeyToResults.get(repoKey);
    }

    /**
     * @return a list of {@link String} objects indcating the repositories with results in this object.
     */
    public Set<String> repositoryKeyset()
    {
        return repoKeyToResults.keySet();
    }
}
