package com.atlassian.user.impl.memory.properties;


import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.properties.PropertySetFactory;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;

import java.util.HashMap;
import java.util.Map;

/**
 * Provides memory propertysets and keeps track of them.
 *
 * A real implementation would split the persistence from the factory.
 *
 * @deprecated since 2.2 because it should not be used in production. Will be moved to test code in 3.0.
 */
public class MemoryPropertySetFactory implements PropertySetFactory
{
    private static final String MEMORY_PROPERTY_SET = "memory";

    private final Map<String, PropertySet> propertySets = new HashMap<String, PropertySet>();

    /**
     * @param entity - the instance of {@link com.atlassian.user.Entity} for which a {@link com.opensymphony.module.propertyset.PropertySet} should be
     *               retrieved.
     * @return an instance of {@link com.opensymphony.module.propertyset.PropertySet} for the {@link com.atlassian.user.Entity}, otherwise null.
     */
    public PropertySet getPropertySet(Entity entity) throws EntityException
    {
        if (entity == null) throw new IllegalArgumentException("Cannot generate a propertyset for a null entity"); 

        PropertySet propertySet = propertySets.get(entity.getName());

        if (propertySet != null)
            return propertySet;

        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("entityName",  "_" + entity.getName());

        propertySet = PropertySetManager.getInstance(MEMORY_PROPERTY_SET, args);

        propertySets.put(entity.getName(), propertySet);

        return propertySet;
    }
}