package com.atlassian.user.configuration;

import com.atlassian.user.repository.RepositoryIdentifier;

import java.util.Set;

/**
 * Represents the configuration of a single repository, with defaults taken from atlassian-user-defaults.xml
 * and override settings coming from atlassian-user.xml.
 * <p/>
 * TODO: At the moment, properties like LDAP host names are retrieved via {@link #getComponent(String)} with a
 * special constant (like {@link Configuration#HOST}). Instead, these properties should be retrieved by
 * a getProperty(String) method on this object.
 */
public interface RepositoryConfiguration
{
    RepositoryIdentifier getIdentifier();

    void addComponent(String componentName, Object component);

    /**
     * Returns the component specified by the name, or <tt>null</tt> if the
     * component does not exist.
     */
    Object getComponent(String componentName);

    /**
     * Returns the component specified by the name, or <tt>null</tt> if the
     * component does not exist.
     *
     * @throws ClassCastException if the specified component can not be cast to a String
     */
    String getStringComponent(String componentName);

    /**
     * Returns <tt>true</tt> if the component exists and is not <tt>null</tt>, otherwise <tt>false</tt>.
     */
    boolean hasComponent(String componentName);

    String getComponentClassName(String componentName);

    RepositoryAccessor configure() throws ConfigurationException;

    boolean hasClassForComponent(String componentName);

    /**
     * @return an unmodifiable Set of the components specified by this configuration.
     */
    Set getComponentNames();

    /**
     * Set the cache configuration to be used for this repository. If caching is to be
     * disabled, you can pass a value of <tt>null</tt>. Caching is disabled by default.
     */
    void setCacheConfiguration(CacheConfiguration cacheConfiguration);

    /**
     * Returns <tt>true</tt> if caching is enabled for this repository, or false
     * if caching is disabled.
     *
     * @see #getCacheConfiguration()
     * @see #setCacheConfiguration(CacheConfiguration)
     */
    boolean isCachingEnabled();

    /**
     * Returns the cache configuration for this repository. If caching is disabled,
     * returns <tt>null</tt>. You should use {@link #isCachingEnabled()} rather than
     * checking explicitly for <tt>null</tt>.
     *
     * @see #isCachingEnabled()
     */
    CacheConfiguration getCacheConfiguration();
}
