/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.search.query;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.DefaultSearchResult;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import com.atlassian.user.search.query.AbstractEntityQueryParser;
import com.atlassian.user.search.query.BooleanQuery;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.FullNameTermQuery;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.GroupsOfUserTwoTermQuery;
import com.atlassian.user.search.query.MembershipQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import com.atlassian.user.search.query.TermQuery;
import com.atlassian.user.search.query.UserNameTermQuery;
import com.atlassian.user.search.query.UsersInGroupTwoTermQuery;
import com.atlassian.user.search.query.match.ContainsIgnoreCaseMatcher;
import com.atlassian.user.search.query.match.EndsWithIgnoreCaseMatcher;
import com.atlassian.user.search.query.match.EqualsIgnoreCaseMatcher;
import com.atlassian.user.search.query.match.Matcher;
import com.atlassian.user.search.query.match.StartsWithIgnoreCaseMatcher;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DefaultEntityQueryParser
extends AbstractEntityQueryParser
implements EntityQueryParser {
    private static final Logger log = Logger.getLogger((Class)DefaultEntityQueryParser.class);
    protected UserManager userManager;
    protected GroupManager groupManager;
    protected RepositoryIdentifier repository;
    protected Method entityNameMethod;
    protected Method emailMethod;
    protected Method fullnameMethod;
    private static final Class userClass = User.class;

    public DefaultEntityQueryParser(RepositoryIdentifier repo, UserManager userManager, GroupManager groupManager) {
        try {
            this.entityNameMethod = userClass.getMethod("getName", null);
            this.emailMethod = userClass.getMethod("getEmail", null);
            this.fullnameMethod = userClass.getMethod("getFullName", null);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e.getMessage());
        }
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.repository = repo;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.userManager = (UserManager)args.get("userManager");
        this.groupManager = (GroupManager)args.get("groupManager");
        this.repository = (RepositoryIdentifier)args.get("repository");
        InitializationCheck.validateArgs(args, new String[]{"userManager", "groupManager", "repository"}, this);
        try {
            this.entityNameMethod = userClass.getMethod("getName", null);
            this.emailMethod = userClass.getMethod("getEmail", null);
            this.fullnameMethod = userClass.getMethod("getFullName", null);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e.getMessage());
        }
    }

    protected Pager parseQuery(Method userMethod, TermQuery q, Pager data) throws IllegalAccessException, InvocationTargetException {
        String searchTerm = StringUtils.defaultString((String)q.getTerm()).toLowerCase();
        if (searchTerm.indexOf("*") >= 0) {
            return data;
        }
        Matcher matcher = q.isMatchingSubstring() ? (q.getMatchingRule().equals("starts_with") ? new StartsWithIgnoreCaseMatcher() : (q.getMatchingRule().equals("ends_with") ? new EndsWithIgnoreCaseMatcher() : new ContainsIgnoreCaseMatcher())) : new EqualsIgnoreCaseMatcher();
        ArrayList<Entity> matches = new ArrayList<Entity>();
        Iterator iterator = data.iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            String userInfo = (String)userMethod.invoke((Object)entity, null);
            if (!matcher.matches(userInfo, searchTerm)) continue;
            matches.add(entity);
        }
        return new DefaultPager(matches);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Pager find(Query query) throws EntityException {
        Pager result = null;
        if (query instanceof TermQuery) {
            try {
                if (query instanceof UserNameTermQuery) {
                    return this.parseQuery(this.entityNameMethod, (TermQuery)query, this.userManager.getUsers());
                }
                if (query instanceof GroupNameTermQuery) {
                    return this.parseQuery(this.entityNameMethod, (TermQuery)query, this.groupManager.getGroups());
                }
                if (query instanceof EmailTermQuery) {
                    return this.parseQuery(this.emailMethod, (TermQuery)query, this.userManager.getUsers());
                }
                if (!(query instanceof FullNameTermQuery)) return result;
                return this.parseQuery(this.fullnameMethod, (TermQuery)query, this.userManager.getUsers());
            }
            catch (IllegalAccessException e) {
                throw new EntityException(e);
            }
            catch (InvocationTargetException e) {
                throw new EntityException(e);
            }
        }
        if (query instanceof MembershipQuery) {
            return this.parseMembershipQuery(query);
        }
        if (!(query instanceof BooleanQuery)) return result;
        BooleanQuery bQuery = (BooleanQuery)query;
        return this.evaluateBoolean(bQuery);
    }

    private Pager parseMembershipQuery(Query query) throws EntityException {
        Pager result = null;
        if (query instanceof UsersInGroupTwoTermQuery) {
            result = this.parseUsersInGroupTwoTermQuery((UsersInGroupTwoTermQuery)query);
        } else if (query instanceof GroupsOfUserTwoTermQuery) {
            result = this.parseGroupsOfUserTwoTermQuery((GroupsOfUserTwoTermQuery)query);
        }
        return result;
    }

    private Pager parseUsersInGroupTwoTermQuery(UsersInGroupTwoTermQuery query) throws EntityException {
        UserNameTermQuery userQuery = query.getUserNameTermQuery();
        GroupNameTermQuery groupQuery = query.getGroupNameTermQuery();
        Pager users = this.find(userQuery);
        Pager groups = this.find(groupQuery);
        Iterator groupsIter = groups.iterator();
        HashSet candidateUsers = new HashSet();
        while (groupsIter.hasNext()) {
            Group group = (Group)groupsIter.next();
            candidateUsers.addAll(PagerUtils.toList(this.groupManager.getLocalMemberNames(group)));
        }
        List userQueryList = PagerUtils.toList(users);
        userQueryList.retainAll(candidateUsers);
        return new DefaultPager(userQueryList);
    }

    private Pager evaluateBoolean(BooleanQuery query) throws EntityException {
        List queries = query.getQueries();
        Pager allResults = null;
        if (query instanceof MembershipQuery) {
            return this.parseMembershipQuery(query);
        }
        boolean anding = query.isAND();
        for (int i = 0; i < queries.size(); ++i) {
            Query nextQuery = (Query)queries.get(i);
            try {
                List initialResult;
                if (allResults == null) {
                    allResults = this.find(nextQuery);
                    continue;
                }
                if (nextQuery instanceof BooleanQuery) {
                    if (anding) {
                        Pager resultsToAnd = this.evaluateBoolean((BooleanQuery)nextQuery);
                        List resultsToAndList = PagerUtils.toList(resultsToAnd);
                        List allResultsList = PagerUtils.toList(allResults);
                        resultsToAndList.retainAll(allResultsList);
                        allResults = new DefaultPager(resultsToAndList);
                        continue;
                    }
                    Pager resultsToOr = this.evaluateBoolean((BooleanQuery)nextQuery);
                    List resultsToOrList = PagerUtils.toList(resultsToOr);
                    List intersection = this.findIntersection(PagerUtils.toList(allResults), resultsToOrList);
                    allResults = new DefaultPager(intersection);
                    continue;
                }
                if (anding) {
                    if (nextQuery instanceof UserNameTermQuery) {
                        initialResult = PagerUtils.toList(this.parseQuery(this.entityNameMethod, (TermQuery)nextQuery, allResults));
                        initialResult.addAll(PagerUtils.toList(allResults));
                        allResults = new DefaultPager(initialResult);
                        continue;
                    }
                    if (nextQuery instanceof GroupNameTermQuery) {
                        initialResult = PagerUtils.toList(this.parseQuery(this.entityNameMethod, (TermQuery)nextQuery, allResults));
                        initialResult.addAll(PagerUtils.toList(allResults));
                        allResults = new DefaultPager(initialResult);
                        continue;
                    }
                    if (nextQuery instanceof EmailTermQuery) {
                        initialResult = PagerUtils.toList(this.parseQuery(this.emailMethod, (TermQuery)nextQuery, allResults));
                        initialResult.addAll(PagerUtils.toList(allResults));
                        allResults = new DefaultPager(initialResult);
                        continue;
                    }
                    if (!(nextQuery instanceof FullNameTermQuery)) continue;
                    initialResult = PagerUtils.toList(this.parseQuery(this.fullnameMethod, (TermQuery)nextQuery, allResults));
                    initialResult.addAll(PagerUtils.toList(allResults));
                    allResults = new DefaultPager(initialResult);
                    continue;
                }
                initialResult = PagerUtils.toList(this.find(nextQuery));
                List intersection = this.findIntersection(PagerUtils.toList(allResults), initialResult);
                allResults = new DefaultPager(intersection);
                continue;
            }
            catch (Exception e) {
                log.error((Object)(e.getClass().getName() + " - " + e.getMessage()));
            }
        }
        return allResults;
    }

    private List findIntersection(List list1, List list2) {
        list2.removeAll(list1);
        list1.addAll(list2);
        return list1;
    }

    private Pager parseGroupsOfUserTwoTermQuery(GroupsOfUserTwoTermQuery query) throws EntityException {
        UserNameTermQuery userQuery = query.getUserNameTermQuery();
        GroupNameTermQuery groupQuery = query.getGroupNameTermQuery();
        Pager groups = this.find(groupQuery);
        Pager users = this.find(userQuery);
        Iterator usersIter = users.iterator();
        HashSet candidateGroups = new HashSet();
        while (usersIter.hasNext()) {
            User user = (User)usersIter.next();
            candidateGroups.addAll(PagerUtils.toList(this.groupManager.getGroups(user)));
        }
        List groupQueryList = PagerUtils.toList(groups);
        groupQueryList.retainAll(candidateGroups);
        return new DefaultPager(groupQueryList);
    }

    public SearchResult findUsers(Query query) throws EntityException {
        this.validateQuery(query);
        Pager pager = this.find(query);
        return new DefaultSearchResult(pager, this.repository.getKey());
    }

    public SearchResult findGroups(Query query) throws EntityException {
        this.validateQuery(query);
        Pager pager = this.find(query);
        return new DefaultSearchResult(pager, this.repository.getKey());
    }

    public SearchResult findUsers(Query query, QueryContext context) throws EntityException {
        this.validateQuery(query);
        SearchResult result = null;
        if (context.getRepositoryKeys().contains(this.repository.getKey()) || context.getRepositoryKeys().contains("_all_repositories_")) {
            result = this.findUsers(query);
        }
        return result;
    }

    public SearchResult findGroups(Query query, QueryContext context) throws EntityException {
        this.validateQuery(query);
        SearchResult result = null;
        if (context.getRepositoryKeys().contains(this.repository.getKey()) || context.getRepositoryKeys().contains("_all_repositories_")) {
            result = this.findGroups(query);
        }
        return result;
    }
}

