/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.impl.delegation.repository.DelegatingRepository;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerFactory;
import com.atlassian.user.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class DelegatingGroupManager
implements GroupManager {
    private static final Logger log = Logger.getLogger((Class)DelegatingGroupManager.class);
    private final List groupManagers;

    public DelegatingGroupManager(List groupManagers) {
        this.groupManagers = groupManagers;
    }

    protected Iterator getGroupManagersIterator() {
        return this.groupManagers.iterator();
    }

    public List getGroupManagers() {
        return Collections.unmodifiableList(this.groupManagers);
    }

    protected GroupManager getMatchingGroupManager(Group group) throws EntityException {
        GroupManager groupManager = null;
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            groupManager = (GroupManager)iter.next();
            Group foundGroup = groupManager.getGroup(group.getName());
            if (foundGroup == null) continue;
            return groupManager;
        }
        return groupManager;
    }

    public Pager getGroups() throws EntityException {
        ArrayList<Pager> groups = new ArrayList<Pager>();
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            try {
                groups.add(groupManager.getGroups());
            }
            catch (EntityException e) {
                log.error((Object)("Failed to retrieve groups from group manager in delegation: " + groupManager.getClass().toString() + ". Continuing with remaining managers."), (Throwable)e);
            }
        }
        return PagerFactory.getPager(groups);
    }

    public Pager getGroups(User user) throws EntityException {
        Assert.notNull(user, "User must not be null");
        Iterator iter = this.getGroupManagersIterator();
        LinkedList<Pager> pagers = new LinkedList<Pager>();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            try {
                Pager groupPager = groupManager.getGroups(user);
                pagers.add(groupPager);
            }
            catch (EntityException e) {
                log.error((Object)("Failed to retrieve groups for user [" + user + "] from group manager: " + groupManager.getClass().toString() + ". Continuing with remaining managers."), (Throwable)e);
            }
        }
        return PagerFactory.getPager(pagers);
    }

    public List getWritableGroups() {
        ArrayList groups = new ArrayList();
        Iterator it = this.getGroupManagersIterator();
        while (it.hasNext()) {
            GroupManager groupManager = (GroupManager)it.next();
            groups.addAll(groupManager.getWritableGroups());
        }
        return groups;
    }

    public Pager getMemberNames(Group group) throws EntityException {
        GroupManager groupManager = this.getMatchingGroupManager(group);
        if (groupManager == null) {
            return new DefaultPager();
        }
        return groupManager.getMemberNames(group);
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        GroupManager groupManager = this.getMatchingGroupManager(group);
        if (groupManager == null) {
            return new DefaultPager();
        }
        return groupManager.getLocalMemberNames(group);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        GroupManager groupManager = this.getMatchingGroupManager(group);
        if (groupManager == null) {
            return new DefaultPager();
        }
        return groupManager.getExternalMemberNames(group);
    }

    public Group getGroup(String groupName) throws EntityException {
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            Group foundGroup = groupManager.getGroup(groupName);
            if (foundGroup == null) continue;
            return foundGroup;
        }
        return null;
    }

    public Group createGroup(String groupName) throws EntityException {
        Iterator iter = this.getGroupManagersIterator();
        Group createdGroup = null;
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            if (groupManager.isCreative()) {
                createdGroup = groupManager.createGroup(groupName);
            }
            if (createdGroup == null) continue;
            return createdGroup;
        }
        return null;
    }

    public void removeGroup(Group group) throws EntityException {
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            if (groupManager.getGroup(group.getName()) == null || groupManager.isReadOnly(group)) continue;
            groupManager.removeGroup(group);
            break;
        }
    }

    public void addMembership(Group group, User user) throws EntityException {
        if (group == null) {
            throw new IllegalArgumentException("Can't add membership for null group");
        }
        GroupManager groupManager = this.getMatchingGroupManager(group);
        groupManager.addMembership(group, user);
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        if (group == null) {
            return false;
        }
        GroupManager groupManager = this.getMatchingGroupManager(group);
        return groupManager.hasMembership(group, user);
    }

    public void removeMembership(Group group, User user) throws EntityException {
        if (group == null) {
            throw new IllegalArgumentException("Can't remove membership for null group");
        }
        GroupManager groupManager = this.getMatchingGroupManager(group);
        groupManager.removeMembership(group, user);
    }

    public boolean supportsExternalMembership() throws EntityException {
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            if (!groupManager.supportsExternalMembership()) continue;
            return true;
        }
        return false;
    }

    public boolean isReadOnly(Group group) throws EntityException {
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            if (groupManager.getGroup(group.getName()) == null) continue;
            return groupManager.isReadOnly(group);
        }
        return false;
    }

    public RepositoryIdentifier getIdentifier() {
        ArrayList<RepositoryIdentifier> repositories = new ArrayList<RepositoryIdentifier>();
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            RepositoryIdentifier repo = groupManager.getIdentifier();
            repositories.add(repo);
        }
        return new DelegatingRepository(repositories);
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (!(entity instanceof Group)) {
            return null;
        }
        GroupManager groupManager = this.getMatchingGroupManager((Group)entity);
        return groupManager.getIdentifier();
    }

    public boolean isCreative() {
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            if (!groupManager.isCreative()) continue;
            return true;
        }
        return false;
    }
}

