/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.configuration.xml;

import com.atlassian.user.configuration.xml.XMLConfigUtil;
import com.atlassian.user.util.ClassLoaderUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class XMLDefaultsParser {
    private static final Logger log = Logger.getLogger((Class)XMLDefaultsParser.class);
    public static final String DEFAULTS_FILE_NAME = "atlassian-user-defaults.xml";
    private final List defaultsBaseNodes = new ArrayList();

    public XMLDefaultsParser() throws IOException, DocumentException {
        this(DEFAULTS_FILE_NAME);
    }

    public XMLDefaultsParser(String defaultsFileName) throws IOException, DocumentException {
        this(new String[]{defaultsFileName});
    }

    private void initialiseDefaultsNodesForFile(String defaultsFileName) throws IOException, DocumentException {
        Enumeration defaultsFileUrls = ClassLoaderUtils.getResources(defaultsFileName, this.getClass());
        while (defaultsFileUrls.hasMoreElements()) {
            URL url = (URL)defaultsFileUrls.nextElement();
            Node defaultsNode = this.findBaseNodeInFile(url);
            if (defaultsNode != null) {
                this.defaultsBaseNodes.add(defaultsNode);
                continue;
            }
            log.error((Object)("Unable to find valid atlassian-user defaults data in file: " + url));
        }
    }

    public XMLDefaultsParser(String[] defaultsFileNames) throws DocumentException, IOException {
        for (int i = 0; i < defaultsFileNames.length; ++i) {
            String defaultsFileName = defaultsFileNames[i];
            this.initialiseDefaultsNodesForFile(defaultsFileName);
        }
        if (this.defaultsBaseNodes.isEmpty()) {
            throw new FileNotFoundException("No valid user defaults files found in classpath with name: " + StringUtils.join((Object[])defaultsFileNames, (String)", "));
        }
    }

    public Map getDefaultClassesConfigForKey(String key) throws DocumentException, IOException {
        HashMap defaults = new HashMap();
        Iterator it = this.defaultsBaseNodes.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            Node defaultsNode = node.selectSingleNode(key);
            if (defaultsNode == null) continue;
            defaults.putAll(XMLConfigUtil.parseRepositoryElementForClassNames((Element)defaultsNode));
        }
        return defaults;
    }

    private Node findBaseNodeInFile(URL url) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(url);
        return doc.selectSingleNode("//default");
    }

    public Map getDefaultParameterConfigForKey(String key) {
        HashMap defaults = new HashMap();
        Iterator it = this.defaultsBaseNodes.iterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            Node defaultsNode = node.selectSingleNode(key);
            if (defaultsNode == null) continue;
            defaults.putAll(XMLConfigUtil.parseRepositoryElementForStringData((Element)defaultsNode));
            break;
        }
        return defaults;
    }
}

