package com.atlassian.user.search;

import com.atlassian.user.Entity;

import java.util.Comparator;
import java.text.Collator;

/**
 * Compares two {@link Entity} objects using their {@link Entity#getName()} methods and
 * a collator (which can be provided to the constructor).
 *
 * Instances of this class are not thread-safe if created with the no-args constructor because
 * the Collator instance used for comparison is not thread-safe.
 */
public class EntityNameAlphaComparator implements Comparator
{
    private final Collator collator;

    public EntityNameAlphaComparator(Collator collator)
    {
        this.collator = collator;
    }

    public EntityNameAlphaComparator()
    {
        collator = Collator.getInstance();
    }

    public int compare(Object o1, Object o2)
    {
        return collator.compare(((Entity)o1).getName(), ((Entity)o2).getName());
    }
}
