package com.atlassian.user.impl.osuser.properties;

import com.atlassian.user.Entity;
import com.atlassian.user.properties.PropertySetFactory;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.user.provider.ProfileProvider;
import org.apache.log4j.Logger;

public class OSUPropertySetFactory implements PropertySetFactory
{
    protected final Logger log = Logger.getLogger(this.getClass());

    private final ProfileProvider profileProvider;

    public OSUPropertySetFactory(ProfileProvider profileProvider)
    {
        this.profileProvider = profileProvider;
    }

    /**
     * returns a propertyset for the entity passed in as long as it is being managed by osuser.
     * if the case of the entity's name is mixed, we will lower it, as all user accounts managed by osuser are lowercase.
     * if we cannot find the user, then return null. (we do not need to create a osupropertyset for a user that is not being managed by OSUSER).
     */
    public PropertySet getPropertySet(Entity entity)
    {
        PropertySet ps = null;

        String entityName = entity.getName();
        if (profileProvider.handles(entityName))
        {
            ps = profileProvider.getPropertySet(entityName);
        }
        else
        {
            // in Confluence and JIRA we lower case usernames
            String lowercasedEntityName = entityName.toLowerCase();
            log.info("No propertyset for user [" + entityName + "]. Trying lower case form - [" + lowercasedEntityName + "]");
            if (profileProvider.handles(lowercasedEntityName)) // always call .handles() first to ensure this user account is being managed by OSUser
                ps = profileProvider.getPropertySet(lowercasedEntityName);
        }

        return ps;
    }
}
