package com.atlassian.user.impl.osuser.configuration;

import com.atlassian.user.configuration.*;
import com.atlassian.user.impl.osuser.OSUAccessor;
import com.atlassian.user.impl.osuser.config.xml.OSUConfigurationLoader;
import com.atlassian.user.util.ClassLoaderUtils;

import java.io.InputStream;

public class OSURepositoryProcessor extends DefaultRepositoryProcessor
{
    public RepositoryAccessor process(RepositoryConfiguration config) throws ConfigurationException
    {
        OSUConfigurationLoader configLoader = (OSUConfigurationLoader) createBean("configLoader", config, false);
        config.addComponent("configLoader", configLoader);

        InputStream configFile = getConfigurationFile(config.getComponentClassName("configFile"));
        configLoader.load(configFile);
        OSUAccessor accessor = configLoader.getOSUAccessor();

        config.addComponent(Configuration.ACCESSOR, accessor);
        config.addComponent(Configuration.OSU_ACCESS_PROVIDER, accessor.getAccessProvider());
        config.addComponent(Configuration.OSU_CREDENTIALS_PROVIDER, accessor.getCredentialsProvider());
        config.addComponent(Configuration.OSU_PROFILE_PROVIDER, accessor.getProfileProvider());
        config.addComponent(Configuration.OSU_CREDENTIALS_PROVIDER_LIST, configLoader.getCredentialProviders());

        return super.process(config);
    }

    private InputStream getConfigurationFile(String configXMLFileName)
        throws ConfigurationException
    {
        InputStream is = ClassLoaderUtils.getResourceAsStream(configXMLFileName, this.getClass());

        if (is == null)
        {
            throw new ConfigurationException("Could not open InputStream on specified configuration file: " +
                "[" + configXMLFileName + "]. Please ensure that the file is available on the classpath.");
        }
        return is;
    }
}
