package com.atlassian.user.impl.memory;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.ReadOnlyGroupManager;
import com.atlassian.user.impl.memory.provider.MemoryProvider;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.Pager;

import java.util.List;
import java.util.Collections;

public class MemoryGroupManagerReadOnly extends ReadOnlyGroupManager
{
    private final RepositoryIdentifier repository;
    private final MemoryProvider provider;

    public MemoryGroupManagerReadOnly(RepositoryIdentifier config, MemoryProvider provider)
    {
        this.repository = config;
        this.provider = provider;
    }

    public Pager getGroups()
    {
        return provider.getGroups();
    }

    public boolean hasMembership(com.atlassian.user.Group group, com.atlassian.user.User user)
    {
        return provider.hasMembership(group, user);
    }

    public boolean supportsExternalMembership() throws EntityException
    {
        return false;
    }

    public com.atlassian.user.Group getGroup(String groupName)
    {
        return provider.getGroup(groupName);
    }

    public Pager getGroups(com.atlassian.user.User user)
    {
        return provider.getGroups(user);
    }

    public void setUserManager(UserManager userManager)
    {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    public Pager getMemberNames(com.atlassian.user.Group group)
    {
        return provider.getMemberNames(group);
    }

    public Pager getLocalMemberNames(Group group) throws EntityException
    {
        return provider.getLocalMemberNames(group);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException
    {
        throw new UnsupportedOperationException("External membership is not supported");
    }

    /**
     * @return the {@link com.atlassian.user.repository.RepositoryIdentifier} which is managed by this instance.
     */
    public RepositoryIdentifier getIdentifier()
    {
        return repository;
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException
    {
        if (getGroup(entity.getName()) != null)
            return repository;
        else
            return null;
    }
}
