package com.atlassian.user.impl.hibernate;

import com.atlassian.user.impl.DefaultGroup;

import java.util.Set;
import java.util.HashSet;

/**
 * A hibernate implementation of a group.
 *
 * This implementation is intended to provide collections of local and external members.
 * These collections are to be used with care as they may cause lazy loading exceptions
 * when used without consideration to the hibernate session that loaded this group.
 *
 * If unsure, use the {@link com.atlassian.user.GroupManager#getGroups(com.atlassian.user.User)} method.
 *
 * See: http://jira.atlassian.com/browse/USER-191
 */
public class DefaultHibernateGroup extends DefaultGroup
{
    private transient Set externalMembers;
    private transient Set localMembers;
    // we depend on the fact that id is NOT-transient
    private long id;

    public DefaultHibernateGroup(){}

    public DefaultHibernateGroup(String name)
    {
        super(name);
        externalMembers = new HashSet();
        localMembers = new HashSet();
    }

    /**
     * For Hibernate's use only.
     *
     * @see com.atlassian.user.GroupManager#hasMembership(com.atlassian.user.Group, com.atlassian.user.User)
     */
    public Set getExternalMembers()
    {
        return externalMembers;
    }

    /**
     * For Hibernate's use only.
     *
     * @see com.atlassian.user.GroupManager#addMembership(com.atlassian.user.Group, com.atlassian.user.User)
     */
    public void setExternalMembers(Set externalMembers)
    {
        this.externalMembers = externalMembers;
    }

    /**
     * For Hibernate's use only.
     *
     * @see com.atlassian.user.GroupManager#hasMembership(com.atlassian.user.Group, com.atlassian.user.User)
     */
    public Set getLocalMembers()
    {
        return localMembers;
    }

    /**
     * For Hibernate's use only.
     *
     * @see com.atlassian.user.GroupManager#addMembership(com.atlassian.user.Group, com.atlassian.user.User)
     */
    public void setLocalMembers(Set localMembers)
    {
        this.localMembers = localMembers;
    }

    public long getId()
    {
        return id;
    }

    public void setId(long id)
    {
        this.id = id;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (!(o instanceof DefaultHibernateGroup)) return false;
        if (!super.equals(o)) return false;

        final DefaultHibernateGroup defaultHibernateGroup = (DefaultHibernateGroup) o;
        return id == defaultHibernateGroup.id;
    }

    public int hashCode()
    {
        int result = super.hashCode();
        result = 29 * result + (int) (id ^ (id >>> 32));
        return result;
    }
}
