package com.atlassian.user.impl.hibernate;

import java.util.Iterator;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Query;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;

import org.springframework.orm.hibernate.HibernateCallback;
import org.springframework.orm.hibernate.SessionFactoryUtils;
import org.springframework.orm.hibernate.support.HibernateDaoSupport;

import com.atlassian.user.ExternalEntity;

public class DefaultExternalEntityDAO extends HibernateDaoSupport implements ExternalEntityDAO
{
    /**
     *  @deprecated since 1.29
     */
    public static final String EXTERNAL_ENTITY_PREFIX = "ATLUSER_";
    public static final String EXTERNAL_ENTITY_TYPE = "EXT";

    public DefaultExternalEntityDAO(SessionFactory sessionFactory)
    {
        setSessionFactory(sessionFactory);
    }

    public ExternalEntity getExternalEntity(final String externalEntityName)
    {
        return (ExternalEntity) getHibernateTemplate().execute(new HibernateCallback()
        {
            public Object doInHibernate(Session session) throws HibernateException
            {
                Query queryObject = session.getNamedQuery("atluser.externalEntity_findExternalEntity");
                SessionFactoryUtils.applyTransactionTimeout(queryObject, getSessionFactory());

                Iterator iterator = queryObject.setString("externalEntityName", externalEntityName).iterate();
                if (iterator.hasNext())
                    return iterator.next();
                else
                    return null;
            }
        });
    }

    public void removeExternalEntity(String externalEntityName)
    {
        getHibernateTemplate().delete(getExternalEntity(externalEntityName));
        getHibernateTemplate().flush();
    }

    public void saveExternalEntity(ExternalEntity externalEntity)
    {
        getHibernateTemplate().save(externalEntity);
        getHibernateTemplate().flush();
    }


    public ExternalEntity createExternalEntity(String externalEntityName)
    {
        DefaultHibernateExternalEntity externalEntity = new DefaultHibernateExternalEntity();
        externalEntity.setName(externalEntityName);
        externalEntity.setType(EXTERNAL_ENTITY_TYPE);
        saveExternalEntity(externalEntity);
        return externalEntity;
    }
}
