package com.atlassian.user.impl;

/**
 * This user keeps a reference to a {@link OSUPasswordEncryptor} to handle password encryption.
 */

import com.atlassian.user.User;
import com.atlassian.user.impl.osuser.security.password.OSUPasswordEncryptor;

public class DefaultUser extends DefaultEntity implements User
{
    protected String fullName;
    protected String email;
    protected String password;

    public DefaultUser(){}

    public DefaultUser(String name)
    {
        super(name);
    }

    public String getFullName()
    {
        return fullName;
    }

    public String getEmail()
    {
        return email;
    }

    public String getPassword()
    {
        return password;
    }

    public void setFullName(String fullName)
    {
        this.fullName = fullName;
    }

    public void setEmail(String email)
    {
        this.email = email;
    }

    public void setPassword(String passw)
    {
        this.password = passw;
    }

    public String toString()
    {
        return name;
    }

    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;

        final DefaultUser that = (DefaultUser) o;

        if (email != null ? !email.equals(that.email) : that.email != null) return false;
        if (fullName != null ? !fullName.equals(that.fullName) : that.fullName != null) return false;
        if (password != null ? !password.equals(that.password) : that.password != null) return false;

        return true;
    }

    public int hashCode()
    {
        int result = super.hashCode();
        result = 29 * result + (fullName != null ? fullName.hashCode() : 0);
        result = 29 * result + (email != null ? email.hashCode() : 0);
        result = 29 * result + (password != null ? password.hashCode() : 0);
        return result;
    }
}
