/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.osuser;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.osuser.OSUAccessor;
import com.atlassian.user.impl.osuser.OSUEntityManager;
import com.atlassian.user.impl.osuser.OSUUser;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.EntityNameAlphaComparator;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.user.ImmutableException;
import com.opensymphony.user.ManagerAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class OSUUserManager
extends OSUEntityManager
implements UserManager {
    private final OSUAccessor accessor;

    public OSUUserManager(RepositoryIdentifier repository, OSUAccessor accessor) {
        super(repository);
        this.accessor = accessor;
    }

    public Pager getUsers() {
        List userNames = this.accessor.getCredentialsProvider().list();
        TreeSet<OSUUser> atlassianUsers = new TreeSet<OSUUser>(EntityNameAlphaComparator.getInstance());
        Iterator iterator = userNames.iterator();
        while (iterator.hasNext()) {
            String username = (String)iterator.next();
            OSUUser user = this.getWrappedOpensymphonyUser(username);
            if (user == null) continue;
            atlassianUsers.add(user);
        }
        return new DefaultPager(atlassianUsers);
    }

    public Pager getUserNames() throws EntityException {
        return new DefaultPager(this.accessor.getCredentialsProvider().list());
    }

    public User getUser(String username) {
        return this.getWrappedOpensymphonyUser(username);
    }

    private OSUUser getWrappedOpensymphonyUser(String username) {
        com.opensymphony.user.User opensymphonyUser = this.getOpensymphonyUser(username);
        return opensymphonyUser == null ? null : new OSUUser(opensymphonyUser);
    }

    private com.opensymphony.user.User getOpensymphonyUser(String username) {
        String lcUsername = username.toLowerCase();
        if (this.accessor.getCredentialsProvider().handles(lcUsername)) {
            return new com.opensymphony.user.User(username.toLowerCase(), (ManagerAccessor)this.accessor);
        }
        return null;
    }

    public User createUser(String username) throws EntityException {
        boolean usernameHandled = this.accessor.getCredentialsProvider().handles(username);
        if (usernameHandled) {
            throw new DuplicateEntityException("User [" + username + "] already exists in credentialsProvider [" + this.accessor.getCredentialsProvider().toString() + "]");
        }
        if (this.accessor.getCredentialsProvider().create(username)) {
            this.accessor.getProfileProvider().create(username);
            return this.getWrappedOpensymphonyUser(username);
        }
        throw new EntityException("Was unable to create user [" + username + "] but the credentials provider [" + this.accessor.getCredentialsProvider().toString() + "] did not say why.");
    }

    public void alterPassword(User user, String plainTextPass) throws EntityException {
        user.setPassword(plainTextPass);
        this.saveUser(user);
    }

    public void removeUser(User user) throws EntityException {
        if (user == null) {
            throw new IllegalArgumentException("Cannot remove a null user: [" + user + "]");
        }
        if (!(user instanceof OSUUser)) {
            throw new IllegalArgumentException("User is not a OSUUser [" + user.getClass().getName());
        }
        if (this.getUser(user.getName()) == null) {
            throw new IllegalArgumentException("User can not be found in this user manager: [" + user + "]");
        }
        String userName = user.getName();
        PropertySet propertySet = this.accessor.getProfileProvider().getPropertySet(userName);
        Iterator i = propertySet.getKeys().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            propertySet.remove(key);
        }
        ArrayList groupsOfUser = this.accessor.getAccessProvider().listGroupsContainingUser(userName);
        groupsOfUser = new ArrayList(groupsOfUser);
        for (int i2 = 0; i2 < groupsOfUser.size(); ++i2) {
            String groupName = (String)groupsOfUser.get(i2);
            this.accessor.getAccessProvider().removeFromGroup(userName, groupName);
        }
        boolean result = this.accessor.getCredentialsProvider().remove(userName);
        if (!result) {
            throw new EntityException("Could not remove user!");
        }
        this.accessor.getProfileProvider().remove(userName);
    }

    public boolean isReadOnly(User user) {
        return this.getUser(user.getName()) == null;
    }

    public void saveUser(User user) throws EntityException {
        com.opensymphony.user.User osUser = this.getOpensymphonyUser(user.getName());
        osUser.setEmail(user.getEmail());
        try {
            osUser.store();
        }
        catch (ImmutableException e) {
            throw new RepositoryException(e);
        }
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        return this.getUser(entity.getName()) == null ? null : this.repository;
    }

    public OSUAccessor getAccessor() {
        return this.accessor;
    }
}

