/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.configuration;

import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.DefaultRepositoryProcessor;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.configuration.RepositoryConfiguration;
import com.atlassian.user.impl.ldap.properties.LdapConnectionProperties;
import com.atlassian.user.impl.ldap.properties.LdapMembershipProperties;
import com.atlassian.user.impl.ldap.properties.LdapSearchProperties;
import com.atlassian.user.impl.ldap.properties.factory.LdapConnectionPropertiesFactory;
import com.atlassian.user.impl.ldap.properties.factory.LdapMembershipPropertiesFactory;
import com.atlassian.user.impl.ldap.properties.factory.LdapSearchPropertiesFactory;
import com.atlassian.user.impl.ldap.repository.DefaultLdapContextFactory;
import com.atlassian.user.impl.ldap.search.DefaultLdapFilterFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class LdapRepositoryProcessor
extends DefaultRepositoryProcessor {
    public RepositoryAccessor process(RepositoryConfiguration config) throws ConfigurationException {
        this.setConnectionPoolProperties(config);
        Properties schemaMappingsProperties = this.parseSchemaMappings(config);
        Properties serverProperties = this.parseLDAPServerConfiguration(config);
        LdapConnectionProperties connectionProperties = new LdapConnectionPropertiesFactory().createInstance(serverProperties);
        LdapSearchProperties searchProperties = new LdapSearchPropertiesFactory().createInstance(schemaMappingsProperties);
        LdapMembershipProperties membershipProperties = new LdapMembershipPropertiesFactory().createInstance(schemaMappingsProperties);
        config.addComponent("connectionProperties", connectionProperties);
        config.addComponent("searchProperties", searchProperties);
        config.addComponent("membershipProperties", membershipProperties);
        config.addComponent("schemaMappings", schemaMappingsProperties);
        config.addComponent("server", serverProperties);
        config.addComponent("contextFactory", new DefaultLdapContextFactory(connectionProperties));
        config.addComponent("filterFactory", new DefaultLdapFilterFactory(searchProperties));
        config.addComponent("userAdaptor", this.createBean("userAdaptor", config));
        config.addComponent("userFactory", this.createBean("userFactory", config));
        config.addComponent("groupFactory", this.createBean("groupFactory", config));
        config.addComponent("groupAdaptor", this.createBean("groupAdaptor", config));
        return super.process(config);
    }

    public void setConnectionPoolProperties(RepositoryConfiguration config) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("com.sun.jndi.ldap.connect.pool.maxsize", config.getComponent("maxSize"));
        properties.put("com.sun.jndi.ldap.connect.pool.initsize", config.getComponent("initSize"));
        properties.put("com.sun.jndi.ldap.connect.pool.prefsize", config.getComponent("prefSize"));
        properties.put("com.sun.jndi.ldap.connect.pool.debug", config.getComponent("debugLevel"));
        properties.put("com.sun.jndi.ldap.connect.pool.protocol", config.getComponent("securityProtocol"));
        properties.put("com.sun.jndi.ldap.connect.pool.authentication", config.getComponent("poolAuthentication"));
        properties.put("com.sun.jndi.ldap.connect.pool.timeout", config.getComponent("timeout"));
        properties.put("javax.net.ssl.trustStore", config.getComponent("trustStore"));
        Iterator it = properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String value = (String)entry.getValue();
            if (value == null) continue;
            System.setProperty((String)entry.getKey(), value);
        }
    }

    public Properties parseLDAPServerConfiguration(RepositoryConfiguration config) {
        Properties serverProperties = new Properties();
        String[] propertyKeys = new String[]{"host", "port", "securityPrincipal", "securityCredential", "securityProtocol", "authentication", "baseContext", "batchSize", "initialContextFactory", "poolingOn"};
        for (int i = 0; i < propertyKeys.length; ++i) {
            String key = propertyKeys[i];
            String value = (String)config.getComponent(key);
            if (value == null) continue;
            serverProperties.put(key, value);
        }
        return serverProperties;
    }

    public Properties parseSchemaMappings(RepositoryConfiguration config) {
        Properties schemaMappingsProperties = new Properties();
        String[] propertyKeys = new String[]{"baseUserNamespace", "baseGroupNamespace", "usernameAttribute", "groupnameAttribute", "userSearchFilter", "groupSearchFilter", "firstnameAttribute", "surnameAttribute", "emailAttribute", "membershipAttribute", "userSearchAllDepths", "groupSearchAllDepths", "useUnqualifiedUsernameForMembershipComparison", "timeToLive"};
        for (int i = 0; i < propertyKeys.length; ++i) {
            String key = propertyKeys[i];
            String value = (String)config.getComponent(key);
            if (value == null) continue;
            schemaMappingsProperties.setProperty(key, value);
        }
        return schemaMappingsProperties;
    }
}

