/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate.search.query;

import com.atlassian.user.EntityException;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.hibernate.DefaultHibernateExternalEntity;
import com.atlassian.user.impl.hibernate.DefaultHibernateGroup;
import com.atlassian.user.impl.hibernate.DefaultHibernateUser;
import com.atlassian.user.impl.hibernate.repository.HibernateRepository;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.DefaultSearchResult;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.query.AbstractEntityQueryParser;
import com.atlassian.user.search.query.AllRepositoriesQueryContext;
import com.atlassian.user.search.query.BooleanQuery;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.EntityQueryException;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.ExternalEntitiesInGroupTwoTermQuery;
import com.atlassian.user.search.query.ExternalEntityNameTermQuery;
import com.atlassian.user.search.query.FullNameTermQuery;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.GroupQuery;
import com.atlassian.user.search.query.GroupsOfExternalEntityTwoTermQuery;
import com.atlassian.user.search.query.GroupsOfUserTwoTermQuery;
import com.atlassian.user.search.query.MembershipQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import com.atlassian.user.search.query.TermQuery;
import com.atlassian.user.search.query.UserNameTermQuery;
import com.atlassian.user.search.query.UserQuery;
import com.atlassian.user.search.query.UsersInGroupTwoTermQuery;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.expression.Criterion;
import net.sf.hibernate.expression.EqExpression;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.expression.Junction;
import net.sf.hibernate.expression.MatchMode;
import org.springframework.orm.hibernate.SessionFactoryUtils;

public class HibernateEntityQueryParser
extends AbstractEntityQueryParser
implements EntityQueryParser {
    private final RepositoryIdentifier identifier;
    private final HibernateRepository repository;

    public HibernateEntityQueryParser(RepositoryIdentifier identifier, HibernateRepository repository) {
        this.identifier = identifier;
        this.repository = repository;
    }

    public SearchResult findUsers(Query query) throws EntityException {
        this.validateQuery(query);
        return this.parseQuery(query);
    }

    public SearchResult findGroups(Query query) throws EntityException {
        this.validateQuery(query);
        return this.parseQuery(query);
    }

    public SearchResult findUsers(Query query, QueryContext context) throws EntityException {
        this.validateQuery(query);
        if (context instanceof AllRepositoriesQueryContext || context.getRepositoryKeys().contains(this.identifier.getKey()) || context.getRepositoryKeys().contains("_all_repositories_")) {
            return this.parseQuery(query);
        }
        return null;
    }

    public SearchResult findGroups(Query query, QueryContext context) throws EntityException {
        this.validateQuery(query);
        if (context instanceof AllRepositoriesQueryContext || context.getRepositoryKeys().contains(this.identifier.getKey()) || context.getRepositoryKeys().contains("_all_repositories_")) {
            return this.parseQuery(query);
        }
        return null;
    }

    private MatchMode getMatchMode(String matchingRule) {
        if (matchingRule.equals("contains")) {
            return MatchMode.ANYWHERE;
        }
        if (matchingRule.equals("ends_with")) {
            return MatchMode.END;
        }
        if (matchingRule.equals("starts_with")) {
            return MatchMode.START;
        }
        return MatchMode.EXACT;
    }

    private String identifyProperty(TermQuery q) {
        String entityProperty = null;
        if (q instanceof UserNameTermQuery) {
            entityProperty = "name";
        } else if (q instanceof EmailTermQuery) {
            entityProperty = "email";
        } else if (q instanceof FullNameTermQuery) {
            entityProperty = "fullName";
        } else if (q instanceof GroupNameTermQuery) {
            entityProperty = "name";
        } else if (q instanceof GroupsOfUserTwoTermQuery) {
            entityProperty = "entity";
        }
        return entityProperty;
    }

    private SearchResult parseQuery(Query q) throws EntityException {
        List result;
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.repository.getSessionFactory(), (boolean)true);
        Query definingQuery = q;
        if (q instanceof BooleanQuery) {
            definingQuery = this.identifyDefiningQuery((BooleanQuery)q);
        }
        try {
            Criteria baseCriteria = this.getBaseCriteria(definingQuery, session);
            baseCriteria = this.identifyAndAddSearchCriteria(q, definingQuery, baseCriteria);
            result = baseCriteria.list();
        }
        catch (HibernateException e) {
            throw new RepositoryException(e);
        }
        return new DefaultSearchResult(new DefaultPager(result), this.identifier.getName());
    }

    private Criteria identifyAndAddSearchCriteria(Query q, Query definingQuery, Criteria baseCriteria) throws EntityQueryException, HibernateException {
        if (q instanceof BooleanQuery) {
            return this.addSearchCriteria((BooleanQuery)q, definingQuery, baseCriteria);
        }
        return this.addSearchCriteria((TermQuery)q, baseCriteria);
    }

    private Criteria addSearchCriteria(BooleanQuery q, Query definingQuery, Criteria baseCriteria) throws EntityQueryException, HibernateException {
        if (definingQuery instanceof MembershipQuery) {
            return this.addMembershipSearchCriteria(q, baseCriteria);
        }
        Junction junction = this.identifyAndOrJunction(q);
        baseCriteria.add((Criterion)junction);
        Iterator iter = q.getQueries().iterator();
        while (iter.hasNext()) {
            Query query = (Query)iter.next();
            if (query instanceof BooleanQuery) {
                this.addSearchCriteria((BooleanQuery)query, definingQuery, baseCriteria);
                continue;
            }
            if (query instanceof TermQuery) {
                junction.add(this.getQueryExpression((TermQuery)query));
                continue;
            }
            throw new EntityQueryException("Unknown query type: [" + query.getClass().getName() + "]");
        }
        return baseCriteria;
    }

    private Junction identifyAndOrJunction(BooleanQuery q) {
        Object junction = q.isAND() ? Expression.conjunction() : Expression.disjunction();
        return junction;
    }

    private Criteria addMembershipSearchCriteria(BooleanQuery q, Criteria baseCriteria) throws HibernateException {
        if (q instanceof GroupsOfUserTwoTermQuery) {
            this.addGroupsOfUserSearchCriteria(q, baseCriteria);
        } else if (q instanceof GroupsOfExternalEntityTwoTermQuery) {
            this.addGroupsOfExternalEntitySearchCriteria(q, baseCriteria);
        }
        return baseCriteria;
    }

    private void addGroupsOfUserSearchCriteria(BooleanQuery q, Criteria baseCriteria) throws HibernateException {
        UserNameTermQuery userNameQuery = ((GroupsOfUserTwoTermQuery)q).getUserNameTermQuery();
        GroupNameTermQuery groupNameQuery = ((GroupsOfUserTwoTermQuery)q).getGroupNameTermQuery();
        if (!groupNameQuery.getTerm().equals("*")) {
            if (groupNameQuery.isMatchingSubstring()) {
                baseCriteria.add(this.getLikeExpression("name", groupNameQuery, false));
            } else {
                baseCriteria.add((Criterion)new EqExpression("name", (Object)groupNameQuery.getTerm(), false));
            }
        }
        if (userNameQuery.isMatchingSubstring()) {
            baseCriteria.createCriteria("localMembers").add(this.getLikeExpression("name", userNameQuery, false));
        } else {
            baseCriteria.createCriteria("localMembers").add((Criterion)new EqExpression("name", (Object)userNameQuery.getTerm(), false));
        }
    }

    private Criterion getLikeExpression(String entityAttribute, TermQuery termQuery, boolean caseInsensitive) {
        if (caseInsensitive) {
            return Expression.ilike((String)entityAttribute, (String)termQuery.getTerm(), (MatchMode)this.getMatchMode(termQuery.getMatchingRule()));
        }
        return Expression.like((String)entityAttribute, (String)termQuery.getTerm(), (MatchMode)this.getMatchMode(termQuery.getMatchingRule()));
    }

    private void addGroupsOfExternalEntitySearchCriteria(BooleanQuery q, Criteria baseCriteria) throws HibernateException {
        ExternalEntityNameTermQuery nameQuery = ((GroupsOfExternalEntityTwoTermQuery)q).getExternalEntityNameTermQuery();
        GroupNameTermQuery groupQuery = ((GroupsOfExternalEntityTwoTermQuery)q).getGroupNameTermQuery();
        if (!groupQuery.getTerm().equals("*")) {
            if (groupQuery.isMatchingSubstring()) {
                baseCriteria.add(this.getLikeExpression("name", groupQuery, false));
            } else {
                baseCriteria.add((Criterion)new EqExpression("name", (Object)groupQuery.getTerm(), false));
            }
        }
        if (nameQuery.isMatchingSubstring()) {
            baseCriteria.createCriteria("externalMembers").add(this.getLikeExpression("name", nameQuery, false));
        } else {
            baseCriteria.createCriteria("externalMembers").add((Criterion)new EqExpression("name", (Object)nameQuery.getTerm(), false));
        }
    }

    private Criteria addSearchCriteria(TermQuery q, Criteria baseCriteria) {
        Criterion expression = this.getQueryExpression(q);
        baseCriteria.add(expression);
        return baseCriteria;
    }

    private Criterion getQueryExpression(TermQuery termQuery) {
        String hqlField = this.identifyProperty(termQuery);
        if (termQuery.isMatchingSubstring()) {
            return this.getLikeExpression(hqlField, termQuery, true);
        }
        return new EqExpression(hqlField, (Object)termQuery.getTerm(), true);
    }

    private Criteria getBaseCriteria(Query query, Session session) {
        Criteria baseCriteria = null;
        if (query instanceof UserQuery) {
            baseCriteria = session.createCriteria(DefaultHibernateUser.class);
        } else if (query instanceof GroupQuery) {
            baseCriteria = session.createCriteria(DefaultHibernateGroup.class);
        } else if (query instanceof UsersInGroupTwoTermQuery) {
            baseCriteria = session.createCriteria(DefaultHibernateUser.class);
        } else if (query instanceof GroupsOfUserTwoTermQuery || query instanceof GroupsOfExternalEntityTwoTermQuery) {
            baseCriteria = session.createCriteria(DefaultHibernateGroup.class);
        } else if (query instanceof ExternalEntitiesInGroupTwoTermQuery) {
            baseCriteria = session.createCriteria(DefaultHibernateExternalEntity.class);
        }
        return baseCriteria;
    }
}

