/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.impl.delegation.repository.DelegatingRepository;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class DelegatingGroupManagerTemplate
implements GroupManager {
    protected GroupManager getMatchingGroupManager(Group group) throws EntityException {
        GroupManager groupManager = null;
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            groupManager = (GroupManager)iter.next();
            Group foundGroup = groupManager.getGroup(group.getName());
            if (foundGroup == null) continue;
            return groupManager;
        }
        return groupManager;
    }

    public Pager getGroups() throws EntityException {
        ArrayList<Pager> groups = new ArrayList<Pager>();
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            groups.add(groupManager.getGroups());
        }
        return PagerFactory.getPager(groups);
    }

    public Pager getGroups(User user) throws EntityException {
        Iterator iter = this.getGroupManagersIterator();
        LinkedList<Pager> pagers = new LinkedList<Pager>();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            Pager groupPager = groupManager.getGroups(user);
            pagers.add(groupPager);
        }
        return PagerFactory.getPager(pagers);
    }

    public Pager getMemberNames(Group group) throws EntityException {
        GroupManager groupManager = this.getManagerForGroup(group);
        if (groupManager == null) {
            return new DefaultPager();
        }
        return groupManager.getMemberNames(group);
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        GroupManager groupManager;
        Pager result = null;
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext() && (result = (groupManager = (GroupManager)iter.next()).getLocalMemberNames(group)) == null) {
        }
        return result;
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        Pager result = null;
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            if (groupManager.supportsExternalMembership()) {
                result = groupManager.getExternalMemberNames(group);
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    public Group getGroup(String groupName) throws EntityException {
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            Group foundGroup = groupManager.getGroup(groupName);
            if (foundGroup == null) continue;
            return foundGroup;
        }
        return null;
    }

    public Group createGroup(String groupName) throws EntityException {
        Iterator iter = this.getGroupManagersIterator();
        Group createdGroup = null;
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            if (groupManager.isCreative()) {
                createdGroup = groupManager.createGroup(groupName);
            }
            if (createdGroup == null) continue;
            return createdGroup;
        }
        return null;
    }

    public void removeGroup(Group group) throws EntityException {
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            if (groupManager.getGroup(group.getName()) == null || groupManager.isReadOnly(group)) continue;
            groupManager.removeGroup(group);
            break;
        }
    }

    public void addMembership(Group group, User user) throws EntityException {
        if (group == null) {
            throw new IllegalArgumentException("Can't add membership for null group");
        }
        GroupManager groupManager = this.getMatchingGroupManager(group);
        groupManager.addMembership(group, user);
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        if (group == null) {
            return false;
        }
        GroupManager groupManager = this.getMatchingGroupManager(group);
        return groupManager.hasMembership(group, user);
    }

    public void removeMembership(Group group, User user) throws EntityException {
        if (group == null) {
            throw new IllegalArgumentException("Can't remove membership for null group");
        }
        GroupManager groupManager = this.getMatchingGroupManager(group);
        groupManager.removeMembership(group, user);
    }

    public boolean supportsExternalMembership() throws EntityException {
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            if (!groupManager.supportsExternalMembership()) continue;
            return true;
        }
        return false;
    }

    public boolean isReadOnly(Group group) throws EntityException {
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            if (groupManager.getGroup(group.getName()) == null) continue;
            return groupManager.isReadOnly(group);
        }
        return false;
    }

    public RepositoryIdentifier getIdentifier() {
        ArrayList<RepositoryIdentifier> repositories = new ArrayList<RepositoryIdentifier>();
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            RepositoryIdentifier repo = groupManager.getIdentifier();
            repositories.add(repo);
        }
        return new DelegatingRepository(repositories);
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (!(entity instanceof Group)) {
            return null;
        }
        GroupManager groupManager = this.getMatchingGroupManager((Group)entity);
        return groupManager.getIdentifier();
    }

    public boolean isCreative() {
        Iterator iter = this.getGroupManagersIterator();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            if (!groupManager.isCreative()) continue;
            return true;
        }
        return false;
    }

    protected abstract Iterator getGroupManagersIterator();

    private GroupManager getManagerForGroup(Group group) throws EntityException {
        Iterator it = this.getGroupManagersIterator();
        while (it.hasNext()) {
            GroupManager groupManager = (GroupManager)it.next();
            if (groupManager.getGroup(group.getName()) == null) continue;
            return groupManager;
        }
        return null;
    }
}

